/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli.SemanticAnalysis;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.authorization.DefaultHiveAuthorizationProvider;
import org.apache.hadoop.hive.ql.session.SessionState;

final class HCatAuthUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HCatAuthUtil.class);

    HCatAuthUtil() {
    }

    public static boolean isAuthorizationEnabled(Configuration conf) {
        if (!HiveConf.getBoolVar(conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED)) {
            return false;
        }
        if (SessionState.get().getAuthorizer() == null || DefaultHiveAuthorizationProvider.class.getName().equals(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER))) {
            LOG.info("Metastore authorizer is skipped for V2 authorizer or DefaultHiveAuthorizationProvider");
            return false;
        }
        return true;
    }
}

