/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hive.hcatalog.common.HCatUtil;
import org.apache.hive.hcatalog.mapreduce.HCatOutputFormat;
import org.apache.hive.hcatalog.mapreduce.OutputJobInfo;
import org.apache.thrift.TException;

final class Security {
    private static final Logger LOG = LoggerFactory.getLogger(HCatOutputFormat.class);

    Security() {
    }

    public static Security getInstance() {
        return LazyHolder.INSTANCE;
    }

    boolean isSecurityEnabled() {
        try {
            Method m = UserGroupInformation.class.getMethod("isSecurityEnabled", new Class[0]);
            return (Boolean)m.invoke(null, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            LOG.info("Security is not supported by this version of hadoop.", e);
        }
        catch (InvocationTargetException e) {
            String msg = "Failed to call isSecurityEnabled()";
            LOG.info(msg, e);
            throw new IllegalStateException(msg, e);
        }
        catch (IllegalAccessException e) {
            String msg = "Failed to call isSecurityEnabled()";
            LOG.info(msg, e);
            throw new IllegalStateException(msg, e);
        }
        return false;
    }

    String getTokenSignature(OutputJobInfo outputJobInfo) {
        Map<String, String> partValues;
        String tableName;
        StringBuilder result = new StringBuilder("");
        String dbName = outputJobInfo.getDatabaseName();
        if (dbName != null) {
            result.append(dbName);
        }
        if ((tableName = outputJobInfo.getTableName()) != null) {
            result.append("." + tableName);
        }
        if ((partValues = outputJobInfo.getPartitionValues()) != null) {
            for (Map.Entry<String, String> entry : partValues.entrySet()) {
                result.append("/");
                result.append(entry.getKey());
                result.append("=");
                result.append(entry.getValue());
            }
        }
        return result.toString();
    }

    void handleSecurity(Credentials credentials, OutputJobInfo outputJobInfo, IMetaStoreClient client, Configuration conf, boolean harRequested) throws IOException, MetaException, TException, Exception {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            org.apache.hadoop.hive.metastore.security.DelegationTokenSelector hiveTokenSelector = new org.apache.hadoop.hive.metastore.security.DelegationTokenSelector();
            Token<? extends AbstractDelegationTokenIdentifier> hiveToken = hiveTokenSelector.selectToken(new Text(), ugi.getTokens());
            LOG.info("Security::handleSecurity(): Checking for pre-existing metastore token... " + (hiveToken == null ? "Not found. Creating a new one." : "Found. Using existing token."));
            if (hiveToken == null) {
                DelegationTokenSelector jtTokenSelector;
                Token jtToken;
                String tokenSignature = this.getTokenSignature(outputJobInfo);
                hiveToken = HCatUtil.extractThriftToken(client.getDelegationToken(ugi.getUserName(), ugi.getUserName()), tokenSignature);
                if (harRequested && (jtToken = (jtTokenSelector = new DelegationTokenSelector()).selectToken(SecurityUtil.buildTokenService((InetSocketAddress)ShimLoader.getHadoopShims().getHCatShim().getResourceManagerAddress(conf)), ugi.getTokens())) == null) {
                    credentials.addToken(new Text("hcat jt token"), HCatUtil.getJobTrackerDelegationToken(conf, ugi.getUserName()));
                }
                credentials.addToken(new Text(ugi.getUserName() + "_" + tokenSignature), hiveToken);
                LOG.info("Security::handleSecurity(): Setting signature of token to: " + tokenSignature);
                conf.set("mapreduce.lib.hcatoutput.token.sig", tokenSignature);
            }
        }
    }

    void handleSecurity(Job job, OutputJobInfo outputJobInfo, IMetaStoreClient client, Configuration conf, boolean harRequested) throws IOException, MetaException, TException, Exception {
        this.handleSecurity(job.getCredentials(), outputJobInfo, client, conf, harRequested);
    }

    void cancelToken(IMetaStoreClient client, JobContext context) throws IOException, MetaException {
        String tokenStrForm = client.getTokenStrForm();
        if (tokenStrForm != null && context.getConfiguration().get("mapreduce.lib.hcatoutput.token.sig") != null) {
            try {
                client.cancelDelegationToken(tokenStrForm);
            }
            catch (TException e) {
                String msg = "Failed to cancel delegation token";
                LOG.error(msg, e);
                throw new IOException(msg, e);
            }
        }
    }

    private static final class LazyHolder {
        public static final Security INSTANCE = new Security();

        private LazyHolder() {
        }
    }
}

