/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.orc.CompressionKind;
import org.apache.orc.FileMetadata;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcProto;
import org.apache.orc.PhysicalWriter;
import org.apache.orc.Reader;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.impl.MemoryManagerImpl;
import org.apache.orc.impl.OrcTail;
import org.apache.orc.impl.ReaderImpl;
import org.apache.orc.impl.WriterImpl;

public class OrcFile {
    private static final Logger LOG = LoggerFactory.getLogger(OrcFile.class);
    public static final String MAGIC = "ORC";
    public static final WriterVersion CURRENT_WRITER = WriterVersion.ORC_135;
    private static ThreadLocal<MemoryManager> memoryManager = null;

    protected OrcFile() {
    }

    public static ReaderOptions readerOptions(Configuration conf) {
        return new ReaderOptions(conf);
    }

    public static Reader createReader(Path path, ReaderOptions options) throws IOException {
        return new ReaderImpl(path, options);
    }

    public static WriterOptions writerOptions(Configuration conf) {
        return new WriterOptions(null, conf);
    }

    public static WriterOptions writerOptions(Properties tableProperties, Configuration conf) {
        return new WriterOptions(tableProperties, conf);
    }

    private static synchronized MemoryManager getStaticMemoryManager(final Configuration conf) {
        if (memoryManager == null) {
            memoryManager = new ThreadLocal<MemoryManager>(){

                @Override
                protected MemoryManager initialValue() {
                    return new MemoryManagerImpl(conf);
                }
            };
        }
        return memoryManager.get();
    }

    public static Writer createWriter(Path path, WriterOptions opts) throws IOException {
        FileSystem fs = opts.getFileSystem() == null ? path.getFileSystem(opts.getConfiguration()) : opts.getFileSystem();
        return new WriterImpl(fs, path, opts);
    }

    static boolean understandFormat(Path path, Reader reader) {
        if (reader.getFileVersion() == Version.FUTURE) {
            LOG.info("Can't merge {} because it has a future version.", (Object)path);
            return false;
        }
        if (reader.getWriterVersion() == WriterVersion.FUTURE) {
            LOG.info("Can't merge {} because it has a future writerVersion.", (Object)path);
            return false;
        }
        return true;
    }

    static boolean readerIsCompatible(TypeDescription schema, Version fileVersion, WriterVersion writerVersion, int rowIndexStride, CompressionKind compression, Map<String, ByteBuffer> userMetadata, Path path, Reader reader) {
        if (!reader.getSchema().equals(schema)) {
            LOG.info("Can't merge {} because of different schemas {} vs {}", path, reader.getSchema(), schema);
            return false;
        }
        if (reader.getCompressionKind() != compression) {
            LOG.info("Can't merge {} because of different compression {} vs {}", new Object[]{path, reader.getCompressionKind(), compression});
            return false;
        }
        if (reader.getFileVersion() != fileVersion) {
            LOG.info("Can't merge {} because of different file versions {} vs {}", new Object[]{path, reader.getFileVersion(), fileVersion});
            return false;
        }
        if (reader.getWriterVersion() != writerVersion) {
            LOG.info("Can't merge {} because of different writer versions {} vs {}", new Object[]{path, reader.getFileVersion(), fileVersion});
            return false;
        }
        if (reader.getRowIndexStride() != rowIndexStride) {
            LOG.info("Can't merge {} because of different row index strides {} vs {}", path, reader.getRowIndexStride(), rowIndexStride);
            return false;
        }
        for (String key : reader.getMetadataKeys()) {
            if (!userMetadata.containsKey(key)) continue;
            ByteBuffer currentValue = userMetadata.get(key);
            ByteBuffer newValue = reader.getMetadataValue(key);
            if (newValue.equals(currentValue)) continue;
            LOG.info("Can't merge {} because of different user metadata {}", (Object)path, (Object)key);
            return false;
        }
        return true;
    }

    static void mergeMetadata(Map<String, ByteBuffer> metadata, Reader reader) {
        for (String key : reader.getMetadataKeys()) {
            metadata.put(key, reader.getMetadataValue(key));
        }
    }

    public static List<Path> mergeFiles(Path outputPath, WriterOptions options, List<Path> inputFiles) throws IOException {
        Writer output = null;
        Configuration conf = options.getConfiguration();
        try {
            byte[] buffer = new byte[]{};
            TypeDescription schema = null;
            CompressionKind compression = null;
            int bufferSize = 0;
            Version fileVersion = null;
            WriterVersion writerVersion = null;
            int rowIndexStride = 0;
            ArrayList<Path> result = new ArrayList<Path>(inputFiles.size());
            HashMap<String, ByteBuffer> userMetadata = new HashMap<String, ByteBuffer>();
            for (Path path : inputFiles) {
                FileSystem fs = path.getFileSystem(conf);
                Reader reader = OrcFile.createReader(path, OrcFile.readerOptions(options.getConfiguration()).filesystem(fs));
                if (!OrcFile.understandFormat(path, reader)) continue;
                if (schema == null) {
                    schema = reader.getSchema();
                    compression = reader.getCompressionKind();
                    bufferSize = reader.getCompressionSize();
                    rowIndexStride = reader.getRowIndexStride();
                    fileVersion = reader.getFileVersion();
                    writerVersion = reader.getWriterVersion();
                    options.blockSize(bufferSize).version(fileVersion).writerVersion(writerVersion).compress(compression).rowIndexStride(rowIndexStride).setSchema(schema);
                    if (compression != CompressionKind.NONE) {
                        options.enforceBufferSize().bufferSize(bufferSize);
                    }
                    OrcFile.mergeMetadata(userMetadata, reader);
                    output = OrcFile.createWriter(outputPath, options);
                } else {
                    if (!OrcFile.readerIsCompatible(schema, fileVersion, writerVersion, rowIndexStride, compression, userMetadata, path, reader)) continue;
                    OrcFile.mergeMetadata(userMetadata, reader);
                    if (bufferSize < reader.getCompressionSize()) {
                        bufferSize = reader.getCompressionSize();
                        ((WriterImpl)output).increaseCompressionSize(bufferSize);
                    }
                }
                List<OrcProto.StripeStatistics> statList = reader.getOrcProtoStripeStatistics();
                FSDataInputStream inputStream = fs.open(path);
                Throwable throwable = null;
                try {
                    int stripeNum = 0;
                    result.add(path);
                    for (StripeInformation stripe : reader.getStripes()) {
                        int length = (int)stripe.getLength();
                        if (buffer.length < length) {
                            buffer = new byte[length];
                        }
                        long offset = stripe.getOffset();
                        inputStream.readFully(offset, buffer, 0, length);
                        output.appendStripe(buffer, 0, length, stripe, statList.get(stripeNum++));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            if (output != null) {
                for (Map.Entry entry : userMetadata.entrySet()) {
                    output.addUserMetadata((String)entry.getKey(), (ByteBuffer)entry.getValue());
                }
                output.close();
            }
            return result;
        }
        catch (IOException ioe) {
            if (output != null) {
                try {
                    output.close();
                }
                catch (Throwable schema) {
                    // empty catch block
                }
                try {
                    FileSystem fs = options.getFileSystem() == null ? outputPath.getFileSystem(conf) : options.getFileSystem();
                    fs.delete(outputPath, false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    public static class WriterOptions
    implements Cloneable {
        private final Configuration configuration;
        private FileSystem fileSystemValue = null;
        private TypeDescription schema = null;
        private long stripeSizeValue;
        private long blockSizeValue;
        private int rowIndexStrideValue;
        private int bufferSizeValue;
        private boolean enforceBufferSize = false;
        private boolean blockPaddingValue;
        private CompressionKind compressValue;
        private MemoryManager memoryManagerValue;
        private Version versionValue;
        private WriterCallback callback;
        private EncodingStrategy encodingStrategy;
        private CompressionStrategy compressionStrategy;
        private double paddingTolerance;
        private String bloomFilterColumns;
        private double bloomFilterFpp;
        private BloomFilterVersion bloomFilterVersion;
        private PhysicalWriter physicalWriter;
        private WriterVersion writerVersion = CURRENT_WRITER;

        protected WriterOptions(Properties tableProperties, Configuration conf) {
            this.configuration = conf;
            this.memoryManagerValue = OrcFile.getStaticMemoryManager(conf);
            this.stripeSizeValue = OrcConf.STRIPE_SIZE.getLong(tableProperties, conf);
            this.blockSizeValue = OrcConf.BLOCK_SIZE.getLong(tableProperties, conf);
            this.rowIndexStrideValue = (int)OrcConf.ROW_INDEX_STRIDE.getLong(tableProperties, conf);
            this.bufferSizeValue = (int)OrcConf.BUFFER_SIZE.getLong(tableProperties, conf);
            this.blockPaddingValue = OrcConf.BLOCK_PADDING.getBoolean(tableProperties, conf);
            this.compressValue = CompressionKind.valueOf(OrcConf.COMPRESS.getString(tableProperties, conf).toUpperCase());
            String versionName = OrcConf.WRITE_FORMAT.getString(tableProperties, conf);
            this.versionValue = Version.byName(versionName);
            String enString = OrcConf.ENCODING_STRATEGY.getString(tableProperties, conf);
            this.encodingStrategy = EncodingStrategy.valueOf(enString);
            String compString = OrcConf.COMPRESSION_STRATEGY.getString(tableProperties, conf);
            this.compressionStrategy = CompressionStrategy.valueOf(compString);
            this.paddingTolerance = OrcConf.BLOCK_PADDING_TOLERANCE.getDouble(tableProperties, conf);
            this.bloomFilterColumns = OrcConf.BLOOM_FILTER_COLUMNS.getString(tableProperties, conf);
            this.bloomFilterFpp = OrcConf.BLOOM_FILTER_FPP.getDouble(tableProperties, conf);
            this.bloomFilterVersion = BloomFilterVersion.fromString(OrcConf.BLOOM_FILTER_WRITE_VERSION.getString(tableProperties, conf));
        }

        public WriterOptions clone() {
            try {
                return (WriterOptions)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)"Expected super.clone() to work");
            }
        }

        public WriterOptions fileSystem(FileSystem value) {
            this.fileSystemValue = value;
            return this;
        }

        public WriterOptions stripeSize(long value) {
            this.stripeSizeValue = value;
            return this;
        }

        public WriterOptions blockSize(long value) {
            this.blockSizeValue = value;
            return this;
        }

        public WriterOptions rowIndexStride(int value) {
            this.rowIndexStrideValue = value;
            return this;
        }

        public WriterOptions bufferSize(int value) {
            this.bufferSizeValue = value;
            return this;
        }

        public WriterOptions enforceBufferSize() {
            this.enforceBufferSize = true;
            return this;
        }

        public WriterOptions blockPadding(boolean value) {
            this.blockPaddingValue = value;
            return this;
        }

        public WriterOptions encodingStrategy(EncodingStrategy strategy) {
            this.encodingStrategy = strategy;
            return this;
        }

        public WriterOptions paddingTolerance(double value) {
            this.paddingTolerance = value;
            return this;
        }

        public WriterOptions bloomFilterColumns(String columns) {
            this.bloomFilterColumns = columns;
            return this;
        }

        public WriterOptions bloomFilterFpp(double fpp) {
            this.bloomFilterFpp = fpp;
            return this;
        }

        public WriterOptions compress(CompressionKind value) {
            this.compressValue = value;
            return this;
        }

        public WriterOptions setSchema(TypeDescription schema) {
            this.schema = schema;
            return this;
        }

        public WriterOptions version(Version value) {
            this.versionValue = value;
            return this;
        }

        public WriterOptions callback(WriterCallback callback) {
            this.callback = callback;
            return this;
        }

        public WriterOptions bloomFilterVersion(BloomFilterVersion version) {
            this.bloomFilterVersion = version;
            return this;
        }

        public WriterOptions physicalWriter(PhysicalWriter writer) {
            this.physicalWriter = writer;
            return this;
        }

        public WriterOptions memory(MemoryManager value) {
            this.memoryManagerValue = value;
            return this;
        }

        protected WriterOptions writerVersion(WriterVersion version) {
            if (version == WriterVersion.FUTURE) {
                throw new IllegalArgumentException("Can't write a future version.");
            }
            this.writerVersion = version;
            return this;
        }

        public boolean getBlockPadding() {
            return this.blockPaddingValue;
        }

        public long getBlockSize() {
            return this.blockSizeValue;
        }

        public String getBloomFilterColumns() {
            return this.bloomFilterColumns;
        }

        public FileSystem getFileSystem() {
            return this.fileSystemValue;
        }

        public Configuration getConfiguration() {
            return this.configuration;
        }

        public TypeDescription getSchema() {
            return this.schema;
        }

        public long getStripeSize() {
            return this.stripeSizeValue;
        }

        public CompressionKind getCompress() {
            return this.compressValue;
        }

        public WriterCallback getCallback() {
            return this.callback;
        }

        public Version getVersion() {
            return this.versionValue;
        }

        public MemoryManager getMemoryManager() {
            return this.memoryManagerValue;
        }

        public int getBufferSize() {
            return this.bufferSizeValue;
        }

        public boolean isEnforceBufferSize() {
            return this.enforceBufferSize;
        }

        public int getRowIndexStride() {
            return this.rowIndexStrideValue;
        }

        public CompressionStrategy getCompressionStrategy() {
            return this.compressionStrategy;
        }

        public EncodingStrategy getEncodingStrategy() {
            return this.encodingStrategy;
        }

        public double getPaddingTolerance() {
            return this.paddingTolerance;
        }

        public double getBloomFilterFpp() {
            return this.bloomFilterFpp;
        }

        public BloomFilterVersion getBloomFilterVersion() {
            return this.bloomFilterVersion;
        }

        public PhysicalWriter getPhysicalWriter() {
            return this.physicalWriter;
        }

        public WriterVersion getWriterVersion() {
            return this.writerVersion;
        }
    }

    public static enum BloomFilterVersion {
        ORIGINAL("original"),
        UTF8("utf8");

        private final String id;

        private BloomFilterVersion(String id) {
            this.id = id;
        }

        public String toString() {
            return this.id;
        }

        public static BloomFilterVersion fromString(String s) {
            for (BloomFilterVersion version : BloomFilterVersion.values()) {
                if (!version.id.equals(s)) continue;
                return version;
            }
            throw new IllegalArgumentException("Unknown BloomFilterVersion " + s);
        }
    }

    public static interface WriterCallback {
        public void preStripeWrite(WriterContext var1) throws IOException;

        public void preFooterWrite(WriterContext var1) throws IOException;
    }

    public static interface WriterContext {
        public Writer getWriter();
    }

    public static class ReaderOptions {
        private final Configuration conf;
        private FileSystem filesystem;
        private long maxLength = Long.MAX_VALUE;
        private OrcTail orcTail;
        private FileMetadata fileMetadata;

        public ReaderOptions(Configuration conf) {
            this.conf = conf;
        }

        public ReaderOptions filesystem(FileSystem fs) {
            this.filesystem = fs;
            return this;
        }

        public ReaderOptions maxLength(long val) {
            this.maxLength = val;
            return this;
        }

        public ReaderOptions orcTail(OrcTail tail) {
            this.orcTail = tail;
            return this;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public FileSystem getFilesystem() {
            return this.filesystem;
        }

        public long getMaxLength() {
            return this.maxLength;
        }

        public OrcTail getOrcTail() {
            return this.orcTail;
        }

        public ReaderOptions fileMetadata(FileMetadata metadata) {
            this.fileMetadata = metadata;
            return this;
        }

        public FileMetadata getFileMetadata() {
            return this.fileMetadata;
        }
    }

    public static enum CompressionStrategy {
        SPEED,
        COMPRESSION;

    }

    public static enum EncodingStrategy {
        SPEED,
        COMPRESSION;

    }

    public static enum WriterVersion {
        ORIGINAL(0),
        HIVE_8732(1),
        HIVE_4243(2),
        HIVE_12055(3),
        HIVE_13083(4),
        ORC_101(5),
        ORC_135(6),
        FUTURE(Integer.MAX_VALUE);

        private final int id;
        private static final WriterVersion[] values;

        public int getId() {
            return this.id;
        }

        private WriterVersion(int id) {
            this.id = id;
        }

        public static WriterVersion from(int val) {
            if (val >= values.length) {
                return FUTURE;
            }
            return values[val];
        }

        public boolean includes(WriterVersion other) {
            return this.id >= other.id;
        }

        static {
            int max = Integer.MIN_VALUE;
            for (WriterVersion v : WriterVersion.values()) {
                if (v.id < 0) {
                    throw new AssertionError();
                }
                if (v.id <= max || WriterVersion.FUTURE.id == v.id) continue;
                max = v.id;
            }
            values = new WriterVersion[max + 1];
            for (WriterVersion v : WriterVersion.values()) {
                if (v.id >= values.length) continue;
                WriterVersion.values[v.id] = v;
            }
        }
    }

    public static enum Version {
        V_0_11("0.11", 0, 11),
        V_0_12("0.12", 0, 12),
        FUTURE("future", Integer.MAX_VALUE, Integer.MAX_VALUE);

        public static final Version CURRENT;
        private final String name;
        private final int major;
        private final int minor;

        private Version(String name, int major, int minor) {
            this.name = name;
            this.major = major;
            this.minor = minor;
        }

        public static Version byName(String name) {
            for (Version version : Version.values()) {
                if (!version.name.equals(name)) continue;
                return version;
            }
            throw new IllegalArgumentException("Unknown ORC version " + name);
        }

        public String getName() {
            return this.name;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        static {
            CURRENT = V_0_12;
        }
    }
}

