/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import io.prestosql.hive.$internal.org.slf4j.Logger;
import io.prestosql.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcConf;

public class MemoryManagerImpl
implements MemoryManager {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryManagerImpl.class);
    private static final int ROWS_BETWEEN_CHECKS = 5000;
    private final long totalMemoryPool;
    private final Map<Path, WriterInfo> writerList = new HashMap<Path, WriterInfo>();
    private long totalAllocation = 0L;
    private double currentScale = 1.0;
    private int rowsAddedSinceCheck = 0;
    private final OwnedLock ownerLock = new OwnedLock();

    public MemoryManagerImpl(Configuration conf) {
        double maxLoad = OrcConf.MEMORY_POOL.getDouble(conf);
        this.totalMemoryPool = Math.round((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * maxLoad);
        this.ownerLock.lock();
    }

    private void checkOwner() {
        if (!this.ownerLock.isHeldByCurrentThread()) {
            LOG.warn("Owner thread expected {}, got {}", (Object)this.ownerLock.getOwner(), (Object)Thread.currentThread());
        }
    }

    @Override
    public void addWriter(Path path, long requestedAllocation, MemoryManager.Callback callback) throws IOException {
        this.checkOwner();
        WriterInfo oldVal = this.writerList.get(path);
        if (oldVal == null) {
            oldVal = new WriterInfo(requestedAllocation, callback);
            this.writerList.put(path, oldVal);
            this.totalAllocation += requestedAllocation;
        } else {
            this.totalAllocation += requestedAllocation - oldVal.allocation;
            oldVal.allocation = requestedAllocation;
            oldVal.callback = callback;
        }
        this.updateScale(true);
    }

    @Override
    public void removeWriter(Path path) throws IOException {
        this.checkOwner();
        WriterInfo val = this.writerList.get(path);
        if (val != null) {
            this.writerList.remove(path);
            this.totalAllocation -= val.allocation;
            if (this.writerList.isEmpty()) {
                this.rowsAddedSinceCheck = 0;
            }
            this.updateScale(false);
        }
        if (this.writerList.isEmpty()) {
            this.rowsAddedSinceCheck = 0;
        }
    }

    public long getTotalMemoryPool() {
        return this.totalMemoryPool;
    }

    public double getAllocationScale() {
        return this.currentScale;
    }

    @Override
    public void addedRow(int rows) throws IOException {
        this.rowsAddedSinceCheck += rows;
        if (this.rowsAddedSinceCheck >= 5000) {
            this.notifyWriters();
        }
    }

    public void notifyWriters() throws IOException {
        this.checkOwner();
        LOG.debug("Notifying writers after " + this.rowsAddedSinceCheck);
        for (WriterInfo writer : this.writerList.values()) {
            boolean flushed = writer.callback.checkMemory(this.currentScale);
            if (!LOG.isDebugEnabled() || !flushed) continue;
            LOG.debug("flushed " + writer.toString());
        }
        this.rowsAddedSinceCheck = 0;
    }

    private void updateScale(boolean isAllocate) throws IOException {
        this.currentScale = this.totalAllocation <= this.totalMemoryPool ? 1.0 : (double)this.totalMemoryPool / (double)this.totalAllocation;
    }

    private static class WriterInfo {
        long allocation;
        MemoryManager.Callback callback;

        WriterInfo(long allocation, MemoryManager.Callback callback) {
            this.allocation = allocation;
            this.callback = callback;
        }
    }

    private static class OwnedLock
    extends ReentrantLock {
        private OwnedLock() {
        }

        @Override
        public Thread getOwner() {
            return super.getOwner();
        }
    }
}

