/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.rcfile.binary;

import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.prestosql.rcfile.ColumnData;
import io.prestosql.rcfile.EncodeOutput;
import io.prestosql.rcfile.RcFileDecoderUtils;
import io.prestosql.rcfile.binary.BinaryColumnEncoding;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.type.Type;

public class TimestampEncoding
implements BinaryColumnEncoding {
    private final Type type;

    public TimestampEncoding(Type type) {
        this.type = type;
    }

    @Override
    public void encodeColumn(Block block, SliceOutput output, EncodeOutput encodeOutput) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (!block.isNull(position)) {
                TimestampEncoding.writeTimestamp(output, this.type.getLong(block, position));
            }
            encodeOutput.closeEntry();
        }
    }

    @Override
    public void encodeValueInto(Block block, int position, SliceOutput output) {
        TimestampEncoding.writeTimestamp(output, this.type.getLong(block, position));
    }

    @Override
    public Block decodeColumn(ColumnData columnData) {
        int size = columnData.rowCount();
        BlockBuilder builder = this.type.createBlockBuilder(null, size);
        Slice slice = columnData.getSlice();
        for (int i = 0; i < size; ++i) {
            int length = columnData.getLength(i);
            if (length != 0) {
                int offset = columnData.getOffset(i);
                long millis = TimestampEncoding.getTimestamp(slice, offset);
                this.type.writeLong(builder, millis);
                continue;
            }
            builder.appendNull();
        }
        return builder.build();
    }

    @Override
    public int getValueOffset(Slice slice, int offset) {
        return 0;
    }

    @Override
    public int getValueLength(Slice slice, int offset) {
        int length = 4;
        if (TimestampEncoding.hasNanosVInt(slice.getByte(offset))) {
            int nanosVintLength = RcFileDecoderUtils.decodeVIntSize(slice, offset + 4);
            length += nanosVintLength;
            if (RcFileDecoderUtils.isNegativeVInt(slice, offset + 4)) {
                length += RcFileDecoderUtils.decodeVIntSize(slice, offset + 4 + nanosVintLength);
            }
        }
        return length;
    }

    @Override
    public void decodeValueInto(BlockBuilder builder, Slice slice, int offset, int length) {
        long millis = TimestampEncoding.getTimestamp(slice, offset);
        this.type.writeLong(builder, millis);
    }

    private static boolean hasNanosVInt(byte b) {
        return b >> 7 != 0;
    }

    private static long getTimestamp(Slice slice, int offset) {
        int lowest31BitsOfSecondsAndFlag = Integer.reverseBytes(slice.getInt(offset));
        long seconds = lowest31BitsOfSecondsAndFlag & Integer.MAX_VALUE;
        offset += 4;
        int nanos = 0;
        if (lowest31BitsOfSecondsAndFlag < 0) {
            byte nanosFirstByte = slice.getByte(offset);
            int nanosLength = RcFileDecoderUtils.decodeVIntSize(nanosFirstByte);
            nanos = (int)RcFileDecoderUtils.readVInt(slice, offset, nanosLength);
            nanos = TimestampEncoding.decodeNanos(nanos);
            if (RcFileDecoderUtils.isNegativeVInt(nanosFirstByte)) {
                long highBits = RcFileDecoderUtils.readVInt(slice, offset + nanosLength);
                seconds |= highBits << 31;
            }
        }
        long millis = seconds * 1000L + (long)(nanos / 1000000);
        return millis;
    }

    private static int decodeNanos(int nanos) {
        if (nanos < 0) {
            nanos = -nanos - 1;
        }
        int nanosDigits = (int)Math.floor(Math.log10(nanos)) + 1;
        int temp = 0;
        while (nanos != 0) {
            temp *= 10;
            temp += nanos % 10;
            nanos /= 10;
        }
        nanos = temp;
        if (nanosDigits < 9) {
            nanos = (int)((double)nanos * Math.pow(10.0, 9 - nanosDigits));
        }
        return nanos;
    }

    private static void writeTimestamp(SliceOutput output, long millis) {
        long seconds = Math.floorDiv(millis, 1000L);
        int nanos = Math.toIntExact(Math.floorMod(millis, 1000L) * 1000000L);
        TimestampEncoding.writeTimestamp(seconds, nanos, output);
    }

    private static void writeTimestamp(long seconds, int nanos, SliceOutput output) {
        boolean hasSecondsHigh32 = seconds < 0L || seconds > Integer.MAX_VALUE;
        int nanosReversed = TimestampEncoding.reverseDecimal(nanos);
        int secondsLow32 = (int)seconds;
        secondsLow32 = nanosReversed == 0 && !hasSecondsHigh32 ? (secondsLow32 &= Integer.MAX_VALUE) : (secondsLow32 |= Integer.MIN_VALUE);
        output.writeInt(Integer.reverseBytes(secondsLow32));
        if (hasSecondsHigh32 || nanosReversed != 0) {
            int value = hasSecondsHigh32 ? ~nanosReversed : nanosReversed;
            RcFileDecoderUtils.writeVInt(output, value);
        }
        if (hasSecondsHigh32) {
            int secondsHigh32 = (int)(seconds >> 31);
            RcFileDecoderUtils.writeVInt(output, secondsHigh32);
        }
    }

    private static int reverseDecimal(int nanos) {
        int decimal = 0;
        if (nanos != 0) {
            for (int counter = 0; counter < 9; ++counter) {
                decimal *= 10;
                decimal += nanos % 10;
                nanos /= 10;
            }
        }
        return decimal;
    }
}

