/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.Preconditions;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class MessageTypeToType
extends ParquetTypeVisitor<Type> {
    private static final Joiner DOT = Joiner.on((String)".");
    private final Map<String, Integer> aliasToId = Maps.newHashMap();
    private final GroupType root;
    private int nextId = 1;

    public MessageTypeToType(GroupType root) {
        this.root = root;
        this.nextId = 1000;
    }

    public Map<String, Integer> getAliases() {
        return this.aliasToId;
    }

    @Override
    public Type message(MessageType message, List<Type> fields) {
        return this.struct((GroupType)message, fields);
    }

    @Override
    public Type struct(GroupType struct, List<Type> fieldTypes) {
        if (struct == this.root) {
            this.nextId = 1;
        }
        List parquetFields = struct.getFields();
        ArrayList fields = Lists.newArrayListWithExpectedSize((int)fieldTypes.size());
        for (int i = 0; i < parquetFields.size(); ++i) {
            org.apache.parquet.schema.Type field = (org.apache.parquet.schema.Type)parquetFields.get(i);
            Preconditions.checkArgument((!field.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Fields cannot have repetition REPEATED: {}", (Object[])new Object[]{field});
            int fieldId = this.getId(field);
            this.addAlias(field.getName(), fieldId);
            if (((org.apache.parquet.schema.Type)parquetFields.get(i)).isRepetition(Type.Repetition.OPTIONAL)) {
                fields.add(Types.NestedField.optional((int)fieldId, (String)field.getName(), (Type)fieldTypes.get(i)));
                continue;
            }
            fields.add(Types.NestedField.required((int)fieldId, (String)field.getName(), (Type)fieldTypes.get(i)));
        }
        return Types.StructType.of((List)fields);
    }

    @Override
    public Type list(GroupType array, Type elementType) {
        GroupType repeated = array.getType(0).asGroupType();
        org.apache.parquet.schema.Type element = repeated.getType(0);
        Preconditions.checkArgument((!element.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Elements cannot have repetition REPEATED: {}", (Object[])new Object[]{element});
        int elementFieldId = this.getId(element);
        this.addAlias(element.getName(), elementFieldId);
        if (element.isRepetition(Type.Repetition.OPTIONAL)) {
            return Types.ListType.ofOptional((int)elementFieldId, (Type)elementType);
        }
        return Types.ListType.ofRequired((int)elementFieldId, (Type)elementType);
    }

    @Override
    public Type map(GroupType map, Type keyType, Type valueType) {
        GroupType keyValue = map.getType(0).asGroupType();
        org.apache.parquet.schema.Type key = keyValue.getType(0);
        org.apache.parquet.schema.Type value = keyValue.getType(1);
        Preconditions.checkArgument((!value.isRepetition(Type.Repetition.REPEATED) ? 1 : 0) != 0, (String)"Values cannot have repetition REPEATED: {}", (Object[])new Object[]{value});
        int keyFieldId = this.getId(key);
        int valueFieldId = this.getId(value);
        this.addAlias(key.getName(), keyFieldId);
        this.addAlias(value.getName(), valueFieldId);
        if (value.isRepetition(Type.Repetition.OPTIONAL)) {
            return Types.MapType.ofOptional((int)keyFieldId, (int)valueFieldId, (Type)keyType, (Type)valueType);
        }
        return Types.MapType.ofRequired((int)keyFieldId, (int)valueFieldId, (Type)keyType, (Type)valueType);
    }

    @Override
    public Type primitive(PrimitiveType primitive) {
        OriginalType annotation = primitive.getOriginalType();
        if (annotation != null) {
            switch (annotation) {
                case INT_8: 
                case UINT_8: 
                case INT_16: 
                case UINT_16: 
                case INT_32: {
                    return Types.IntegerType.get();
                }
                case INT_64: {
                    return Types.LongType.get();
                }
                case DATE: {
                    return Types.DateType.get();
                }
                case TIME_MILLIS: 
                case TIME_MICROS: {
                    return Types.TimeType.get();
                }
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    return Types.TimestampType.withZone();
                }
                case JSON: 
                case BSON: 
                case ENUM: 
                case UTF8: {
                    return Types.StringType.get();
                }
                case DECIMAL: {
                    DecimalMetadata decimal = primitive.getDecimalMetadata();
                    return Types.DecimalType.of((int)decimal.getPrecision(), (int)decimal.getScale());
                }
            }
            throw new UnsupportedOperationException("Unsupported logical type: " + annotation);
        }
        switch (primitive.getPrimitiveTypeName()) {
            case BOOLEAN: {
                return Types.BooleanType.get();
            }
            case INT32: {
                return Types.IntegerType.get();
            }
            case INT64: {
                return Types.LongType.get();
            }
            case FLOAT: {
                return Types.FloatType.get();
            }
            case DOUBLE: {
                return Types.DoubleType.get();
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return Types.FixedType.ofLength((int)primitive.getTypeLength());
            }
            case BINARY: {
                return Types.BinaryType.get();
            }
        }
        throw new UnsupportedOperationException("Cannot convert unknown primitive type: " + primitive);
    }

    private void addAlias(int fieldId) {
        if (!this.fieldNames.isEmpty()) {
            String fullName = DOT.join(this.fieldNames.descendingIterator());
            this.aliasToId.put(fullName, fieldId);
        }
    }

    private void addAlias(String name, int fieldId) {
        String fullName = name;
        if (!this.fieldNames.isEmpty()) {
            fullName = DOT.join((Object)DOT.join(this.fieldNames.descendingIterator()), (Object)name, new Object[0]);
        }
        this.aliasToId.put(fullName, fieldId);
    }

    protected int nextId() {
        int current = this.nextId++;
        return current;
    }

    private int getId(org.apache.parquet.schema.Type type) {
        Type.ID id = type.getId();
        if (id != null) {
            return id.intValue();
        }
        return this.nextId();
    }
}

