/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.ParquetAvro;
import org.apache.iceberg.parquet.ParquetFilters;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetIterable;
import org.apache.iceberg.parquet.ParquetReadSupport;
import org.apache.iceberg.parquet.ParquetReader;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetWriteAdapter;
import org.apache.iceberg.parquet.ParquetWriteSupport;
import org.apache.iceberg.parquet.ParquetWriter;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.avro.AvroWriteSupport;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.schema.MessageType;

public class Parquet {
    private static Collection<String> READ_PROPERTIES_TO_REMOVE = Sets.newHashSet((Object[])new String[]{"parquet.read.filter", "parquet.private.read.filter.predicate", "parquet.read.support.class"});

    private Parquet() {
    }

    public static WriteBuilder write(org.apache.iceberg.io.OutputFile file) {
        return new WriteBuilder(file);
    }

    public static ReadBuilder read(InputFile file) {
        return new ReadBuilder(file);
    }

    private static class ParquetReadBuilder<T>
    extends ParquetReader.Builder<T> {
        private Schema schema = null;
        private ReadSupport<T> readSupport = null;
        private boolean callInit = false;

        private ParquetReadBuilder(org.apache.parquet.io.InputFile file) {
            super(file);
        }

        public ParquetReadBuilder<T> project(Schema schema) {
            this.schema = schema;
            return this;
        }

        public ParquetReadBuilder<T> readSupport(ReadSupport<T> readSupport) {
            this.readSupport = readSupport;
            return this;
        }

        public ParquetReadBuilder<T> callInit() {
            this.callInit = true;
            return this;
        }

        protected ReadSupport<T> getReadSupport() {
            return new ParquetReadSupport<T>(this.schema, this.readSupport, this.callInit);
        }
    }

    public static class ReadBuilder {
        private final InputFile file;
        private Long start = null;
        private Long length = null;
        private Schema schema = null;
        private Expression filter = null;
        private ReadSupport<?> readSupport = null;
        private Function<MessageType, ParquetValueReader<?>> readerFunc = null;
        private boolean filterRecords = true;
        private boolean caseSensitive = true;
        private Map<String, String> properties = Maps.newHashMap();
        private boolean callInit = false;
        private boolean reuseContainers = false;

        private ReadBuilder(InputFile file) {
            this.file = file;
        }

        public ReadBuilder split(long start, long length) {
            this.start = start;
            this.length = length;
            return this;
        }

        public ReadBuilder project(Schema schema) {
            this.schema = schema;
            return this;
        }

        public ReadBuilder caseInsensitive() {
            return this.caseSensitive(false);
        }

        public ReadBuilder caseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public ReadBuilder filterRecords(boolean filterRecords) {
            this.filterRecords = filterRecords;
            return this;
        }

        public ReadBuilder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public ReadBuilder readSupport(ReadSupport<?> readSupport) {
            this.readSupport = readSupport;
            return this;
        }

        public ReadBuilder createReaderFunc(Function<MessageType, ParquetValueReader<?>> readerFunc) {
            this.readerFunc = readerFunc;
            return this;
        }

        public ReadBuilder set(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public ReadBuilder callInit() {
            this.callInit = true;
            return this;
        }

        public ReadBuilder reuseContainers() {
            this.reuseContainers = true;
            return this;
        }

        public <D> CloseableIterable<D> build() {
            if (this.readerFunc != null) {
                ParquetReadOptions.Builder optionsBuilder;
                if (this.file instanceof HadoopInputFile) {
                    Configuration conf = new Configuration(((HadoopInputFile)this.file).getConf());
                    for (String property : READ_PROPERTIES_TO_REMOVE) {
                        conf.unset(property);
                    }
                    optionsBuilder = HadoopReadOptions.builder((Configuration)conf);
                } else {
                    optionsBuilder = ParquetReadOptions.builder();
                }
                for (Map.Entry entry : this.properties.entrySet()) {
                    optionsBuilder.set((String)entry.getKey(), (String)entry.getValue());
                }
                if (this.start != null) {
                    optionsBuilder.withRange(this.start.longValue(), this.start + this.length);
                }
                ParquetReadOptions options = optionsBuilder.build();
                return new ParquetReader(this.file, this.schema, options, this.readerFunc, this.filter, this.reuseContainers, this.caseSensitive);
            }
            ParquetReadBuilder builder = new ParquetReadBuilder(ParquetIO.file(this.file));
            builder.project(this.schema);
            if (this.readSupport != null) {
                builder.readSupport(this.readSupport);
            } else {
                builder.readSupport(new AvroReadSupport(ParquetAvro.DEFAULT_MODEL));
            }
            builder.set("parquet.strict.typing", "false").set("parquet.avro.compatible", "false").set("parquet.avro.add-list-element-records", "false");
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                builder.set(entry.getKey(), entry.getValue());
            }
            if (this.filter != null) {
                MessageType type;
                try (ParquetFileReader parquetFileReader = ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file(this.file));){
                    type = parquetFileReader.getFileMetaData().getSchema();
                }
                catch (IOException iOException) {
                    throw new RuntimeIOException(iOException);
                }
                Schema schema = ParquetSchemaUtil.convert(type);
                builder.useStatsFilter().useDictionaryFilter().useRecordFilter(this.filterRecords).withFilter(ParquetFilters.convert(schema, this.filter, this.caseSensitive));
            } else {
                builder.useStatsFilter(false).useDictionaryFilter(false).useRecordFilter(false);
            }
            if (this.callInit) {
                builder.callInit();
            }
            if (this.start != null) {
                builder.withFileRange(this.start, this.start + this.length);
            }
            return new ParquetIterable(builder);
        }
    }

    private static class ParquetWriteBuilder<T>
    extends ParquetWriter.Builder<T, ParquetWriteBuilder<T>> {
        private Map<String, String> keyValueMetadata = Maps.newHashMap();
        private Map<String, String> config = Maps.newHashMap();
        private MessageType type;
        private WriteSupport<T> writeSupport;

        private ParquetWriteBuilder(OutputFile path) {
            super(path);
        }

        protected ParquetWriteBuilder<T> self() {
            return this;
        }

        public ParquetWriteBuilder<T> setKeyValueMetadata(Map<String, String> keyValueMetadata) {
            this.keyValueMetadata = keyValueMetadata;
            return this.self();
        }

        public ParquetWriteBuilder<T> setConfig(Map<String, String> config) {
            this.config = config;
            return this.self();
        }

        public ParquetWriteBuilder<T> setType(MessageType type) {
            this.type = type;
            return this.self();
        }

        public ParquetWriteBuilder<T> setWriteSupport(WriteSupport<T> writeSupport) {
            this.writeSupport = writeSupport;
            return this.self();
        }

        protected WriteSupport<T> getWriteSupport(Configuration configuration) {
            for (Map.Entry<String, String> entry : this.config.entrySet()) {
                configuration.set(entry.getKey(), entry.getValue());
            }
            return new ParquetWriteSupport<T>(this.type, this.keyValueMetadata, this.writeSupport);
        }
    }

    public static class WriteBuilder {
        private final org.apache.iceberg.io.OutputFile file;
        private Schema schema = null;
        private String name = "table";
        private WriteSupport<?> writeSupport = null;
        private Map<String, String> metadata = Maps.newLinkedHashMap();
        private Map<String, String> config = Maps.newLinkedHashMap();
        private Function<MessageType, ParquetValueWriter<?>> createWriterFunc = null;
        private MetricsConfig metricsConfig = MetricsConfig.getDefault();

        private WriteBuilder(org.apache.iceberg.io.OutputFile file) {
            this.file = file;
        }

        public WriteBuilder forTable(Table table) {
            this.schema(table.schema());
            this.setAll(table.properties());
            this.metricsConfig(MetricsConfig.fromProperties((Map)table.properties()));
            return this;
        }

        public WriteBuilder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        public WriteBuilder named(String name) {
            this.name = name;
            return this;
        }

        public WriteBuilder writeSupport(WriteSupport<?> writeSupport) {
            this.writeSupport = writeSupport;
            return this;
        }

        public WriteBuilder set(String property, String value) {
            this.config.put(property, value);
            return this;
        }

        public WriteBuilder setAll(Map<String, String> properties) {
            this.config.putAll(properties);
            return this;
        }

        public WriteBuilder meta(String property, String value) {
            this.metadata.put(property, value);
            return this;
        }

        public WriteBuilder createWriterFunc(Function<MessageType, ParquetValueWriter<?>> createWriterFunc) {
            this.createWriterFunc = createWriterFunc;
            return this;
        }

        public WriteBuilder metricsConfig(MetricsConfig newMetricsConfig) {
            this.metricsConfig = newMetricsConfig;
            return this;
        }

        private <T> WriteSupport<T> getWriteSupport(MessageType type) {
            if (this.writeSupport != null) {
                return this.writeSupport;
            }
            return new AvroWriteSupport(type, ParquetAvro.parquetAvroSchema(AvroSchemaUtil.convert((Schema)this.schema, (String)this.name)), ParquetAvro.DEFAULT_MODEL);
        }

        private CompressionCodecName codec() {
            String codec = this.config.getOrDefault("write.parquet.compression-codec", "gzip");
            try {
                return CompressionCodecName.valueOf((String)codec.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unsupported compression codec: " + codec);
            }
        }

        public <D> FileAppender<D> build() throws IOException {
            Preconditions.checkNotNull((Object)this.schema, (Object)"Schema is required");
            Preconditions.checkNotNull((Object)this.name, (Object)"Table name is required and cannot be null");
            this.meta("iceberg.schema", SchemaParser.toJson((Schema)this.schema));
            int rowGroupSize = Integer.parseInt(this.config.getOrDefault("write.parquet.row-group-size-bytes", "134217728"));
            int pageSize = Integer.parseInt(this.config.getOrDefault("write.parquet.page-size-bytes", "1048576"));
            int dictionaryPageSize = Integer.parseInt(this.config.getOrDefault("write.parquet.dict-size-bytes", "2097152"));
            ParquetProperties.WriterVersion writerVersion = ParquetProperties.WriterVersion.PARQUET_1_0;
            this.set("parquet.avro.write-old-list-structure", "false");
            MessageType type = ParquetSchemaUtil.convert(this.schema, this.name);
            if (this.createWriterFunc != null) {
                Preconditions.checkArgument((this.writeSupport == null ? 1 : 0) != 0, (Object)"Cannot write with both write support and Parquet value writer");
                Configuration conf = this.file instanceof HadoopOutputFile ? ((HadoopOutputFile)this.file).getConf() : new Configuration();
                for (Map.Entry<String, String> entry : this.config.entrySet()) {
                    conf.set(entry.getKey(), entry.getValue());
                }
                ParquetProperties parquetProperties = ParquetProperties.builder().withWriterVersion(writerVersion).withPageSize(pageSize).withDictionaryPageSize(dictionaryPageSize).build();
                return new ParquetWriter(conf, this.file, this.schema, rowGroupSize, this.metadata, this.createWriterFunc, this.codec(), parquetProperties, this.metricsConfig);
            }
            return new ParquetWriteAdapter(((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)((ParquetWriteBuilder)new ParquetWriteBuilder(ParquetIO.file(this.file)).withWriterVersion(writerVersion)).setType(type).setConfig(this.config).setKeyValueMetadata(this.metadata).setWriteSupport(this.getWriteSupport(type)).withCompressionCodec(this.codec())).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withRowGroupSize(rowGroupSize)).withPageSize(pageSize)).withDictionaryPageSize(dictionaryPageSize)).build(), this.metricsConfig);
        }
    }
}

