/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.specific.SpecificData;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.UUIDConversion;
import org.apache.iceberg.types.TypeUtil;

class ParquetAvro {
    static GenericData DEFAULT_MODEL;

    ParquetAvro() {
    }

    static Schema parquetAvroSchema(Schema avroSchema) {
        return (Schema)AvroSchemaVisitor.visit((Schema)avroSchema, (AvroSchemaVisitor)new ParquetDecimalSchemaConverter());
    }

    static {
        LogicalTypes.register((String)"parquet-decimal", schema -> {
            int precision = Integer.parseInt(schema.getProp("precision"));
            int scale = Integer.parseInt(schema.getProp("scale"));
            return new ParquetDecimal(precision, scale);
        });
        DEFAULT_MODEL = new SpecificData(){
            private final Conversion<?> fixedDecimalConversion = new FixedDecimalConversion();
            private final Conversion<?> intDecimalConversion = new IntDecimalConversion();
            private final Conversion<?> longDecimalConversion = new LongDecimalConversion();
            private final Conversion<?> uuidConversion = new UUIDConversion();
            {
                this.addLogicalTypeConversion(this.fixedDecimalConversion);
                this.addLogicalTypeConversion(this.uuidConversion);
            }

            public <T> Conversion<T> getConversionByClass(Class<T> datumClass, LogicalType logicalType) {
                if (logicalType == null) {
                    return null;
                }
                if (logicalType instanceof ParquetDecimal) {
                    ParquetDecimal decimal = (ParquetDecimal)logicalType;
                    if (decimal.precision() <= 9) {
                        return this.intDecimalConversion;
                    }
                    if (decimal.precision() <= 18) {
                        return this.longDecimalConversion;
                    }
                    return this.fixedDecimalConversion;
                }
                if ("uuid".equals(logicalType.getName())) {
                    return this.uuidConversion;
                }
                return super.getConversionByClass(datumClass, logicalType);
            }

            public Conversion<Object> getConversionFor(LogicalType logicalType) {
                if (logicalType == null) {
                    return null;
                }
                if (logicalType instanceof LogicalTypes.Decimal) {
                    LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                    if (decimal.getPrecision() <= 9) {
                        return this.intDecimalConversion;
                    }
                    if (decimal.getPrecision() <= 18) {
                        return this.longDecimalConversion;
                    }
                    return this.fixedDecimalConversion;
                }
                if ("uuid".equals(logicalType.getName())) {
                    return this.uuidConversion;
                }
                return super.getConversionFor(logicalType);
            }
        };
    }

    private static class ParquetDecimalSchemaConverter
    extends AvroSchemaVisitor<Schema> {
        private ParquetDecimalSchemaConverter() {
        }

        public Schema record(Schema record, List<String> names, List<Schema> types) {
            List fields = record.getFields();
            int length = fields.size();
            boolean hasChange = false;
            if (length != types.size()) {
                hasChange = true;
            }
            ArrayList newFields = Lists.newArrayListWithExpectedSize((int)length);
            for (int i = 0; i < length; ++i) {
                Schema.Field field = (Schema.Field)fields.get(i);
                Schema type = types.get(i);
                newFields.add(ParquetDecimalSchemaConverter.copyField(field, type));
                if (field.schema() == type) continue;
                hasChange = true;
            }
            if (hasChange) {
                return ParquetDecimalSchemaConverter.copyRecord(record, newFields);
            }
            return record;
        }

        public Schema union(Schema union, List<Schema> options) {
            if (!this.isIdentical(union.getTypes(), options)) {
                return Schema.createUnion(options);
            }
            return union;
        }

        public Schema array(Schema array, Schema element) {
            if (array.getElementType() != element) {
                return Schema.createArray((Schema)element);
            }
            return array;
        }

        public Schema map(Schema map, Schema value) {
            if (map.getValueType() != value) {
                return Schema.createMap((Schema)value);
            }
            return map;
        }

        public Schema primitive(Schema primitive) {
            LogicalType logicalType = primitive.getLogicalType();
            if (logicalType != null && logicalType instanceof LogicalTypes.Decimal) {
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                if (decimal.getPrecision() <= 9) {
                    return new ParquetDecimal(decimal.getPrecision(), decimal.getScale()).addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
                }
                if (decimal.getPrecision() <= 18) {
                    return new ParquetDecimal(decimal.getPrecision(), decimal.getScale()).addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
                }
                return new ParquetDecimal(decimal.getPrecision(), decimal.getScale()).addToSchema(Schema.createFixed((String)primitive.getName(), null, null, (int)TypeUtil.decimalRequriedBytes((int)decimal.getPrecision())));
            }
            return primitive;
        }

        private boolean isIdentical(List<Schema> types, List<Schema> replacements) {
            if (types.size() != replacements.size()) {
                return false;
            }
            int length = types.size();
            for (int i = 0; i < length; ++i) {
                if (types.get(i) == replacements.get(i)) continue;
                return false;
            }
            return true;
        }

        private static Schema copyRecord(Schema record, List<Schema.Field> newFields) {
            Schema copy = Schema.createRecord((String)record.getName(), (String)record.getDoc(), (String)record.getNamespace(), (boolean)record.isError(), newFields);
            for (Map.Entry prop : record.getObjectProps().entrySet()) {
                copy.addProp((String)prop.getKey(), prop.getValue());
            }
            return copy;
        }

        private static Schema.Field copyField(Schema.Field field, Schema newSchema) {
            Schema.Field copy = new Schema.Field(field.name(), newSchema, field.doc(), field.defaultVal(), field.order());
            for (Map.Entry prop : field.getObjectProps().entrySet()) {
                copy.addProp((String)prop.getKey(), prop.getValue());
            }
            return copy;
        }
    }

    private static class FixedDecimalConversion
    extends Conversions.DecimalConversion {
        private final LogicalType[] decimalsByScale = new LogicalType[39];

        private FixedDecimalConversion() {
            for (int i = 0; i < this.decimalsByScale.length; ++i) {
                this.decimalsByScale[i] = LogicalTypes.decimal((int)i, (int)i);
            }
        }

        public String getLogicalTypeName() {
            return "parquet-decimal";
        }

        public BigDecimal fromFixed(GenericFixed value, Schema schema, LogicalType type) {
            return super.fromFixed(value, schema, this.decimalsByScale[((ParquetDecimal)type).scale()]);
        }

        public GenericFixed toFixed(BigDecimal value, Schema schema, LogicalType type) {
            return super.toFixed(value, schema, this.decimalsByScale[((ParquetDecimal)type).scale()]);
        }
    }

    private static class LongDecimalConversion
    extends Conversion<BigDecimal> {
        private LongDecimalConversion() {
        }

        public Class<BigDecimal> getConvertedType() {
            return BigDecimal.class;
        }

        public String getLogicalTypeName() {
            return "parquet-decimal";
        }

        public BigDecimal fromLong(Long value, Schema schema, LogicalType type) {
            return BigDecimal.valueOf(value, ((ParquetDecimal)type).scale());
        }

        public Long toLong(BigDecimal value, Schema schema, LogicalType type) {
            return value.unscaledValue().longValue();
        }
    }

    private static class IntDecimalConversion
    extends Conversion<BigDecimal> {
        private IntDecimalConversion() {
        }

        public Class<BigDecimal> getConvertedType() {
            return BigDecimal.class;
        }

        public String getLogicalTypeName() {
            return "parquet-decimal";
        }

        public BigDecimal fromInt(Integer value, Schema schema, LogicalType type) {
            return BigDecimal.valueOf(value.intValue(), ((ParquetDecimal)type).scale());
        }

        public Integer toInt(BigDecimal value, Schema schema, LogicalType type) {
            return value.unscaledValue().intValue();
        }
    }

    static class ParquetDecimal
    extends LogicalType {
        private static final String NAME = "parquet-decimal";
        private int precision;
        private int scale;

        ParquetDecimal(int precision, int scale) {
            super(NAME);
            this.precision = precision;
            this.scale = scale;
        }

        public String getName() {
            return NAME;
        }

        int precision() {
            return this.precision;
        }

        int scale() {
            return this.scale;
        }

        public Schema addToSchema(Schema schema) {
            super.addToSchema(schema);
            schema.addProp("precision", String.valueOf(this.precision));
            schema.addProp("scale", String.valueOf(this.scale));
            return schema;
        }

        public void validate(Schema schema) {
            super.validate(schema);
            switch (schema.getType()) {
                case INT: {
                    Preconditions.checkArgument((this.precision <= 9 ? 1 : 0) != 0, (String)"Int cannot hold decimal precision: %s", (int)this.precision);
                    break;
                }
                case LONG: {
                    Preconditions.checkArgument((this.precision <= 18 ? 1 : 0) != 0, (String)"Long cannot hold decimal precision: %s", (int)this.precision);
                }
                case FIXED: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid base type for decimal: " + schema);
                }
            }
            Preconditions.checkArgument((this.scale >= 0 ? 1 : 0) != 0, (String)"Scale %s cannot be negative", (int)this.scale);
            Preconditions.checkArgument((this.scale <= this.precision ? 1 : 0) != 0, (String)"Scale %s cannot be less than precision %s", (int)this.scale, (int)this.precision);
        }
    }
}

