/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.IndexedRecord;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.ParquetValueWriters;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class ParquetAvroWriter {
    private ParquetAvroWriter() {
    }

    public static <T> ParquetValueWriter<T> buildWriter(MessageType type) {
        return (ParquetValueWriter)ParquetTypeVisitor.visit((Type)type, new WriteBuilder(type));
    }

    private static class RecordWriter
    extends ParquetValueWriters.StructWriter<IndexedRecord> {
        private RecordWriter(List<ParquetValueWriter<?>> writers) {
            super(writers);
        }

        @Override
        protected Object get(IndexedRecord struct, int index) {
            return struct.get(index);
        }
    }

    private static class FixedWriter
    extends ParquetValueWriters.PrimitiveWriter<GenericData.Fixed> {
        private FixedWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, GenericData.Fixed buffer) {
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])buffer.bytes()));
        }
    }

    private static class WriteBuilder
    extends ParquetTypeVisitor<ParquetValueWriter<?>> {
        private final MessageType type;

        WriteBuilder(MessageType type) {
            this.type = type;
        }

        @Override
        public ParquetValueWriter<?> message(MessageType message, List<ParquetValueWriter<?>> fieldWriters) {
            return this.struct(message.asGroupType(), (List)fieldWriters);
        }

        @Override
        public ParquetValueWriter<?> struct(GroupType struct, List<ParquetValueWriter<?>> fieldWriters) {
            List fields = struct.getFields();
            ArrayList writers = Lists.newArrayListWithExpectedSize((int)fieldWriters.size());
            for (int i = 0; i < fields.size(); ++i) {
                Type fieldType = struct.getType(i);
                int fieldD = this.type.getMaxDefinitionLevel(this.path(fieldType.getName()));
                writers.add(ParquetValueWriters.option(fieldType, fieldD, fieldWriters.get(i)));
            }
            return new RecordWriter(writers);
        }

        @Override
        public ParquetValueWriter<?> list(GroupType array, ParquetValueWriter<?> elementWriter) {
            GroupType repeated = ((Type)array.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type elementType = repeated.getType(0);
            int elementD = this.type.getMaxDefinitionLevel(this.path(elementType.getName()));
            return ParquetValueWriters.collections(repeatedD, repeatedR, ParquetValueWriters.option(elementType, elementD, elementWriter));
        }

        @Override
        public ParquetValueWriter<?> map(GroupType map, ParquetValueWriter<?> keyWriter, ParquetValueWriter<?> valueWriter) {
            GroupType repeatedKeyValue = ((Type)map.getFields().get(0)).asGroupType();
            String[] repeatedPath = this.currentPath();
            int repeatedD = this.type.getMaxDefinitionLevel(repeatedPath);
            int repeatedR = this.type.getMaxRepetitionLevel(repeatedPath);
            Type keyType = repeatedKeyValue.getType(0);
            int keyD = this.type.getMaxDefinitionLevel(this.path(keyType.getName()));
            Type valueType = repeatedKeyValue.getType(1);
            int valueD = this.type.getMaxDefinitionLevel(this.path(valueType.getName()));
            return ParquetValueWriters.maps(repeatedD, repeatedR, ParquetValueWriters.option(keyType, keyD, keyWriter), ParquetValueWriters.option(valueType, valueD, valueWriter));
        }

        @Override
        public ParquetValueWriter<?> primitive(PrimitiveType primitive) {
            ColumnDescriptor desc = this.type.getColumnDescription(this.currentPath());
            if (primitive.getOriginalType() != null) {
                switch (primitive.getOriginalType()) {
                    case ENUM: 
                    case JSON: 
                    case UTF8: {
                        return ParquetValueWriters.strings(desc);
                    }
                    case DATE: 
                    case INT_8: 
                    case INT_16: 
                    case INT_32: 
                    case INT_64: 
                    case TIME_MICROS: 
                    case TIMESTAMP_MICROS: {
                        return ParquetValueWriters.unboxed(desc);
                    }
                    case DECIMAL: {
                        DecimalMetadata decimal = primitive.getDecimalMetadata();
                        switch (primitive.getPrimitiveTypeName()) {
                            case INT32: {
                                return ParquetValueWriters.decimalAsInteger(desc, decimal.getPrecision(), decimal.getScale());
                            }
                            case INT64: {
                                return ParquetValueWriters.decimalAsLong(desc, decimal.getPrecision(), decimal.getScale());
                            }
                            case BINARY: 
                            case FIXED_LEN_BYTE_ARRAY: {
                                return ParquetValueWriters.decimalAsFixed(desc, decimal.getPrecision(), decimal.getScale());
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported base type for decimal: " + primitive.getPrimitiveTypeName());
                    }
                    case BSON: {
                        return ParquetValueWriters.byteBuffers(desc);
                    }
                }
                throw new UnsupportedOperationException("Unsupported logical type: " + primitive.getOriginalType());
            }
            switch (primitive.getPrimitiveTypeName()) {
                case FIXED_LEN_BYTE_ARRAY: {
                    return new FixedWriter(desc);
                }
                case BINARY: {
                    return ParquetValueWriters.byteBuffers(desc);
                }
                case INT32: 
                case INT64: 
                case BOOLEAN: 
                case FLOAT: 
                case DOUBLE: {
                    return ParquetValueWriters.unboxed(desc);
                }
            }
            throw new UnsupportedOperationException("Unsupported type: " + primitive);
        }

        private String[] currentPath() {
            String[] path = new String[this.fieldNames.size()];
            if (!this.fieldNames.isEmpty()) {
                Iterator iter = this.fieldNames.descendingIterator();
                int i = 0;
                while (iter.hasNext()) {
                    path[i] = (String)iter.next();
                    ++i;
                }
            }
            return path;
        }

        private String[] path(String name) {
            String[] path = new String[this.fieldNames.size() + 1];
            path[this.fieldNames.size()] = name;
            if (!this.fieldNames.isEmpty()) {
                Iterator iter = this.fieldNames.descendingIterator();
                int i = 0;
                while (iter.hasNext()) {
                    path[i] = (String)iter.next();
                    ++i;
                }
            }
            return path;
        }
    }
}

