/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.parquet.ParquetAvro;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;

class ParquetReadSupport<T>
extends ReadSupport<T> {
    private final Schema expectedSchema;
    private final ReadSupport<T> wrapped;
    private final boolean callInit;

    ParquetReadSupport(Schema expectedSchema, ReadSupport<T> readSupport, boolean callInit) {
        this.expectedSchema = expectedSchema;
        this.wrapped = readSupport;
        this.callInit = callInit;
    }

    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        MessageType projection = ParquetSchemaUtil.hasIds(fileSchema) ? ParquetSchemaUtil.pruneColumns(fileSchema, this.expectedSchema) : ParquetSchemaUtil.pruneColumnsFallback(fileSchema, this.expectedSchema);
        configuration.set("parquet.strict.typing", "false");
        configuration.set("parquet.avro.add-list-element-records", "false");
        configuration.set("parquet.avro.write-old-list-structure", "false");
        AvroReadSupport.setRequestedProjection((Configuration)configuration, (org.apache.avro.Schema)AvroSchemaUtil.convert((Schema)this.expectedSchema, (String)projection.getName()));
        org.apache.avro.Schema avroReadSchema = AvroSchemaUtil.buildAvroProjection((org.apache.avro.Schema)AvroSchemaUtil.convert((Schema)ParquetSchemaUtil.convert(projection), (String)projection.getName()), (Schema)this.expectedSchema, (Map)ImmutableMap.of());
        AvroReadSupport.setAvroReadSchema((Configuration)configuration, (org.apache.avro.Schema)ParquetAvro.parquetAvroSchema(avroReadSchema));
        ReadSupport.ReadContext context = null;
        if (this.callInit) {
            try {
                context = this.wrapped.init(configuration, keyValueMetaData, projection);
            }
            catch (UnsupportedOperationException e) {
                context = this.wrapped.init(new InitContext(configuration, this.makeMultimap(keyValueMetaData), projection));
            }
        }
        return new ReadSupport.ReadContext(projection, context != null ? context.getReadSupportMetadata() : ImmutableMap.of());
    }

    public RecordMaterializer<T> prepareForRead(Configuration configuration, Map<String, String> fileMetadata, MessageType fileMessageType, ReadSupport.ReadContext readContext) {
        MessageType readSchema = ParquetSchemaUtil.convert(this.expectedSchema, fileMessageType.getName());
        return this.wrapped.prepareForRead(configuration, fileMetadata, readSchema, readContext);
    }

    private Map<String, Set<String>> makeMultimap(Map<String, String> map) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)Sets.newHashSet((Object[])new String[]{entry.getValue()}));
        }
        return builder.build();
    }
}

