/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.parquet.ParquetDictionaryRowGroupFilter;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetMetricsRowGroupFilter;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetValueReader;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.schema.MessageType;

public class ParquetReader<T>
extends CloseableGroup
implements CloseableIterable<T> {
    private final InputFile input;
    private final Schema expectedSchema;
    private final ParquetReadOptions options;
    private final Function<MessageType, ParquetValueReader<?>> readerFunc;
    private final Expression filter;
    private final boolean reuseContainers;
    private final boolean caseSensitive;
    private ReadConf<T> conf = null;

    public ParquetReader(InputFile input, Schema expectedSchema, ParquetReadOptions options, Function<MessageType, ParquetValueReader<?>> readerFunc, Expression filter, boolean reuseContainers, boolean caseSensitive) {
        this.input = input;
        this.expectedSchema = expectedSchema;
        this.options = options;
        this.readerFunc = readerFunc;
        this.filter = filter == Expressions.alwaysTrue() ? null : filter;
        this.reuseContainers = reuseContainers;
        this.caseSensitive = caseSensitive;
    }

    private ReadConf<T> init() {
        if (this.conf == null) {
            ReadConf conf = new ReadConf(this.input, this.options, this.expectedSchema, this.filter, this.readerFunc, this.reuseContainers, this.caseSensitive);
            this.conf = conf.copy();
            return conf;
        }
        return this.conf;
    }

    public Iterator<T> iterator() {
        FileIterator<T> iter = new FileIterator<T>(this.init());
        this.addCloseable(iter);
        return iter;
    }

    private static class FileIterator<T>
    implements Iterator<T>,
    Closeable {
        private final ParquetFileReader reader;
        private final boolean[] shouldSkip;
        private final ParquetValueReader<T> model;
        private final long totalValues;
        private final boolean reuseContainers;
        private int nextRowGroup = 0;
        private long nextRowGroupStart = 0L;
        private long valuesRead = 0L;
        private T last = null;

        FileIterator(ReadConf<T> conf) {
            this.reader = conf.reader();
            this.shouldSkip = conf.shouldSkip();
            this.model = conf.model();
            this.totalValues = conf.totalValues();
            this.reuseContainers = conf.reuseContainers();
        }

        @Override
        public boolean hasNext() {
            return this.valuesRead < this.totalValues;
        }

        @Override
        public T next() {
            if (this.valuesRead >= this.nextRowGroupStart) {
                this.advance();
            }
            this.last = this.reuseContainers ? this.model.read(this.last) : this.model.read(null);
            ++this.valuesRead;
            return this.last;
        }

        private void advance() {
            PageReadStore pages;
            while (this.shouldSkip[this.nextRowGroup]) {
                ++this.nextRowGroup;
                this.reader.skipNextRowGroup();
            }
            try {
                pages = this.reader.readNextRowGroup();
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            this.nextRowGroupStart += pages.getRowCount();
            ++this.nextRowGroup;
            this.model.setPageSource(pages);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }

    private static class ReadConf<T> {
        private final ParquetFileReader reader;
        private final InputFile file;
        private final ParquetReadOptions options;
        private final MessageType projection;
        private final ParquetValueReader<T> model;
        private final List<BlockMetaData> rowGroups;
        private final boolean[] shouldSkip;
        private final long totalValues;
        private final boolean reuseContainers;

        ReadConf(InputFile file, ParquetReadOptions options, Schema expectedSchema, Expression filter, Function<MessageType, ParquetValueReader<?>> readerFunc, boolean reuseContainers, boolean caseSensitive) {
            this.file = file;
            this.options = options;
            this.reader = ReadConf.newReader(file, options);
            MessageType fileSchema = this.reader.getFileMetaData().getSchema();
            boolean hasIds = ParquetSchemaUtil.hasIds(fileSchema);
            MessageType typeWithIds = hasIds ? fileSchema : ParquetSchemaUtil.addFallbackIds(fileSchema);
            this.projection = hasIds ? ParquetSchemaUtil.pruneColumns(fileSchema, expectedSchema) : ParquetSchemaUtil.pruneColumnsFallback(fileSchema, expectedSchema);
            this.model = readerFunc.apply(typeWithIds);
            this.rowGroups = this.reader.getRowGroups();
            this.shouldSkip = new boolean[this.rowGroups.size()];
            ParquetMetricsRowGroupFilter statsFilter = null;
            ParquetDictionaryRowGroupFilter dictFilter = null;
            if (filter != null) {
                statsFilter = new ParquetMetricsRowGroupFilter(expectedSchema, filter, caseSensitive);
                dictFilter = new ParquetDictionaryRowGroupFilter(expectedSchema, filter, caseSensitive);
            }
            long totalValues = 0L;
            for (int i = 0; i < this.shouldSkip.length; ++i) {
                BlockMetaData rowGroup = this.rowGroups.get(i);
                boolean shouldRead = filter == null || statsFilter.shouldRead(typeWithIds, rowGroup) && dictFilter.shouldRead(typeWithIds, rowGroup, (DictionaryPageReadStore)this.reader.getDictionaryReader(rowGroup));
                boolean bl = this.shouldSkip[i] = !shouldRead;
                if (!shouldRead) continue;
                totalValues += rowGroup.getRowCount();
            }
            this.totalValues = totalValues;
            this.reuseContainers = reuseContainers;
        }

        ReadConf(ReadConf<T> toCopy) {
            this.reader = null;
            this.file = toCopy.file;
            this.options = toCopy.options;
            this.projection = toCopy.projection;
            this.model = toCopy.model;
            this.rowGroups = toCopy.rowGroups;
            this.shouldSkip = toCopy.shouldSkip;
            this.totalValues = toCopy.totalValues;
            this.reuseContainers = toCopy.reuseContainers;
        }

        ParquetFileReader reader() {
            if (this.reader != null) {
                this.reader.setRequestedSchema(this.projection);
                return this.reader;
            }
            ParquetFileReader newReader = ReadConf.newReader(this.file, this.options);
            newReader.setRequestedSchema(this.projection);
            return newReader;
        }

        ParquetValueReader<T> model() {
            return this.model;
        }

        boolean[] shouldSkip() {
            return this.shouldSkip;
        }

        long totalValues() {
            return this.totalValues;
        }

        boolean reuseContainers() {
            return this.reuseContainers;
        }

        ReadConf<T> copy() {
            return new ReadConf<T>(this);
        }

        private static ParquetFileReader newReader(InputFile file, ParquetReadOptions options) {
            try {
                return ParquetFileReader.open((org.apache.parquet.io.InputFile)ParquetIO.file(file), (ParquetReadOptions)options);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to open Parquet file: %s", new Object[]{file.location()});
            }
        }
    }
}

