/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avro.util.Utf8;
import org.apache.iceberg.parquet.ColumnWriter;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.parquet.TripleWriter;
import org.apache.iceberg.types.TypeUtil;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.Type;

public class ParquetValueWriters {
    private ParquetValueWriters() {
    }

    public static <T> ParquetValueWriter<T> option(Type type, int definitionLevel, ParquetValueWriter<T> writer) {
        if (type.isRepetition(Type.Repetition.OPTIONAL)) {
            return new OptionWriter<T>(definitionLevel, writer);
        }
        return writer;
    }

    public static <T> UnboxedWriter<T> unboxed(ColumnDescriptor desc) {
        return new UnboxedWriter(desc);
    }

    public static PrimitiveWriter<CharSequence> strings(ColumnDescriptor desc) {
        return new StringWriter(desc);
    }

    public static PrimitiveWriter<BigDecimal> decimalAsInteger(ColumnDescriptor desc, int precision, int scale) {
        return new IntegerDecimalWriter(desc, precision, scale);
    }

    public static PrimitiveWriter<BigDecimal> decimalAsLong(ColumnDescriptor desc, int precision, int scale) {
        return new LongDecimalWriter(desc, precision, scale);
    }

    public static PrimitiveWriter<BigDecimal> decimalAsFixed(ColumnDescriptor desc, int precision, int scale) {
        return new FixedDecimalWriter(desc, precision, scale);
    }

    public static PrimitiveWriter<ByteBuffer> byteBuffers(ColumnDescriptor desc) {
        return new BytesWriter(desc);
    }

    public static <E> CollectionWriter<E> collections(int dl, int rl, ParquetValueWriter<E> writer) {
        return new CollectionWriter(dl, rl, writer);
    }

    public static <K, V> MapWriter<K, V> maps(int dl, int rl, ParquetValueWriter<K> keyWriter, ParquetValueWriter<V> valueWriter) {
        return new MapWriter(dl, rl, keyWriter, valueWriter);
    }

    public static abstract class StructWriter<S>
    implements ParquetValueWriter<S> {
        private final ParquetValueWriter<Object>[] writers;
        private final List<TripleWriter<?>> children;

        protected StructWriter(List<ParquetValueWriter<?>> writers) {
            this.writers = (ParquetValueWriter[])Array.newInstance(ParquetValueWriter.class, writers.size());
            ImmutableList.Builder columnsBuilder = ImmutableList.builder();
            for (int i = 0; i < writers.size(); ++i) {
                ParquetValueWriter<?> writer = writers.get(i);
                this.writers[i] = writer;
                columnsBuilder.addAll(writer.columns());
            }
            this.children = columnsBuilder.build();
        }

        @Override
        public void write(int repetitionLevel, S value) {
            for (int i = 0; i < this.writers.length; ++i) {
                Object fieldValue = this.get(value, i);
                this.writers[i].write(repetitionLevel, fieldValue);
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            for (ParquetValueWriter<Object> writer : this.writers) {
                writer.setColumnStore(columnStore);
            }
        }

        protected abstract Object get(S var1, int var2);
    }

    private static class MapWriter<K, V>
    extends RepeatedKeyValueWriter<Map<K, V>, K, V> {
        private MapWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<K> keyWriter, ParquetValueWriter<V> valueWriter) {
            super(definitionLevel, repetitionLevel, keyWriter, valueWriter);
        }

        @Override
        protected Iterator<Map.Entry<K, V>> pairs(Map<K, V> map) {
            return map.entrySet().iterator();
        }
    }

    public static abstract class RepeatedKeyValueWriter<M, K, V>
    implements ParquetValueWriter<M> {
        private final int definitionLevel;
        private final int repetitionLevel;
        private final ParquetValueWriter<K> keyWriter;
        private final ParquetValueWriter<V> valueWriter;
        private final List<TripleWriter<?>> children;

        protected RepeatedKeyValueWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<K> keyWriter, ParquetValueWriter<V> valueWriter) {
            this.definitionLevel = definitionLevel;
            this.repetitionLevel = repetitionLevel;
            this.keyWriter = keyWriter;
            this.valueWriter = valueWriter;
            this.children = ImmutableList.builder().addAll(keyWriter.columns()).addAll(valueWriter.columns()).build();
        }

        @Override
        public void write(int parentRepetition, M value) {
            Iterator<Map.Entry<K, V>> pairs = this.pairs(value);
            if (!pairs.hasNext()) {
                for (TripleWriter<?> column : this.children) {
                    column.writeNull(parentRepetition, this.definitionLevel - 1);
                }
            } else {
                boolean first = true;
                while (pairs.hasNext()) {
                    Map.Entry<K, V> pair = pairs.next();
                    int rl = this.repetitionLevel;
                    if (first) {
                        rl = parentRepetition;
                        first = false;
                    }
                    this.keyWriter.write(rl, pair.getKey());
                    this.valueWriter.write(rl, pair.getValue());
                }
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.keyWriter.setColumnStore(columnStore);
            this.valueWriter.setColumnStore(columnStore);
        }

        protected abstract Iterator<Map.Entry<K, V>> pairs(M var1);
    }

    private static class CollectionWriter<E>
    extends RepeatedWriter<Collection<E>, E> {
        private CollectionWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<E> writer) {
            super(definitionLevel, repetitionLevel, writer);
        }

        @Override
        protected Iterator<E> elements(Collection<E> list) {
            return list.iterator();
        }
    }

    public static abstract class RepeatedWriter<L, E>
    implements ParquetValueWriter<L> {
        private final int definitionLevel;
        private final int repetitionLevel;
        private final ParquetValueWriter<E> writer;
        private final List<TripleWriter<?>> children;

        protected RepeatedWriter(int definitionLevel, int repetitionLevel, ParquetValueWriter<E> writer) {
            this.definitionLevel = definitionLevel;
            this.repetitionLevel = repetitionLevel;
            this.writer = writer;
            this.children = writer.columns();
        }

        @Override
        public void write(int parentRepetition, L value) {
            Iterator<E> elements = this.elements(value);
            if (!elements.hasNext()) {
                for (TripleWriter<?> column : this.children) {
                    column.writeNull(parentRepetition, this.definitionLevel - 1);
                }
            } else {
                boolean first = true;
                while (elements.hasNext()) {
                    E element = elements.next();
                    int rl = this.repetitionLevel;
                    if (first) {
                        rl = parentRepetition;
                        first = false;
                    }
                    this.writer.write(rl, element);
                }
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.writer.setColumnStore(columnStore);
        }

        protected abstract Iterator<E> elements(L var1);
    }

    static class OptionWriter<T>
    implements ParquetValueWriter<T> {
        private final int definitionLevel;
        private final ParquetValueWriter<T> writer;
        private final List<TripleWriter<?>> children;

        OptionWriter(int definitionLevel, ParquetValueWriter<T> writer) {
            this.definitionLevel = definitionLevel;
            this.writer = writer;
            this.children = writer.columns();
        }

        @Override
        public void write(int repetitionLevel, T value) {
            if (value != null) {
                this.writer.write(repetitionLevel, value);
            } else {
                for (TripleWriter<?> column : this.children) {
                    column.writeNull(repetitionLevel, this.definitionLevel - 1);
                }
            }
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.writer.setColumnStore(columnStore);
        }
    }

    private static class StringWriter
    extends PrimitiveWriter<CharSequence> {
        private StringWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, CharSequence value) {
            if (value instanceof Utf8) {
                Utf8 utf8 = (Utf8)value;
                this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])utf8.getBytes(), (int)0, (int)utf8.getByteLength()));
            } else {
                this.column.writeBinary(repetitionLevel, Binary.fromString((String)value.toString()));
            }
        }
    }

    private static class BytesWriter
    extends PrimitiveWriter<ByteBuffer> {
        private BytesWriter(ColumnDescriptor desc) {
            super(desc);
        }

        @Override
        public void write(int repetitionLevel, ByteBuffer buffer) {
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteBuffer((ByteBuffer)buffer));
        }
    }

    private static class FixedDecimalWriter
    extends PrimitiveWriter<BigDecimal> {
        private final int precision;
        private final int scale;
        private final int length;
        private final ThreadLocal<byte[]> bytes;

        private FixedDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
            this.length = TypeUtil.decimalRequriedBytes((int)precision);
            this.bytes = ThreadLocal.withInitial(() -> new byte[this.length]);
        }

        @Override
        public void write(int repetitionLevel, BigDecimal decimal) {
            Preconditions.checkArgument((decimal.scale() == this.scale ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument((decimal.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            byte fillByte = (byte)(decimal.signum() < 0 ? 255 : 0);
            byte[] unscaled = decimal.unscaledValue().toByteArray();
            byte[] buf = this.bytes.get();
            int offset = this.length - unscaled.length;
            for (int i = 0; i < this.length; ++i) {
                buf[i] = i < offset ? fillByte : unscaled[i - offset];
            }
            this.column.writeBinary(repetitionLevel, Binary.fromReusedByteArray((byte[])buf));
        }
    }

    private static class LongDecimalWriter
    extends PrimitiveWriter<BigDecimal> {
        private final int precision;
        private final int scale;

        private LongDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public void write(int repetitionLevel, BigDecimal decimal) {
            Preconditions.checkArgument((decimal.scale() == this.scale ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument((decimal.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            this.column.writeLong(repetitionLevel, decimal.unscaledValue().longValue());
        }
    }

    private static class IntegerDecimalWriter
    extends PrimitiveWriter<BigDecimal> {
        private final int precision;
        private final int scale;

        private IntegerDecimalWriter(ColumnDescriptor desc, int precision, int scale) {
            super(desc);
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public void write(int repetitionLevel, BigDecimal decimal) {
            Preconditions.checkArgument((decimal.scale() == this.scale ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), wrong scale: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            Preconditions.checkArgument((decimal.precision() <= this.precision ? 1 : 0) != 0, (String)"Cannot write value as decimal(%s,%s), too large: %s", (Object)this.precision, (Object)this.scale, (Object)decimal);
            this.column.writeInteger(repetitionLevel, decimal.unscaledValue().intValue());
        }
    }

    private static class UnboxedWriter<T>
    extends PrimitiveWriter<T> {
        private UnboxedWriter(ColumnDescriptor desc) {
            super(desc);
        }

        public void writeBoolean(int repetitionLevel, boolean value) {
            this.column.writeBoolean(repetitionLevel, value);
        }

        public void writeInteger(int repetitionLevel, int value) {
            this.column.writeInteger(repetitionLevel, value);
        }

        public void writeLong(int repetitionLevel, long value) {
            this.column.writeLong(repetitionLevel, value);
        }

        public void writeFloat(int repetitionLevel, float value) {
            this.column.writeFloat(repetitionLevel, value);
        }

        public void writeDouble(int repetitionLevel, double value) {
            this.column.writeDouble(repetitionLevel, value);
        }
    }

    public static abstract class PrimitiveWriter<T>
    implements ParquetValueWriter<T> {
        private final ColumnDescriptor desc;
        protected final ColumnWriter<T> column;
        private final List<TripleWriter<?>> children;

        protected PrimitiveWriter(ColumnDescriptor desc) {
            this.desc = desc;
            this.column = ColumnWriter.newWriter(desc);
            this.children = ImmutableList.of(this.column);
        }

        @Override
        public void write(int repetitionLevel, T value) {
            this.column.write(repetitionLevel, value);
        }

        @Override
        public List<TripleWriter<?>> columns() {
            return this.children;
        }

        @Override
        public void setColumnStore(ColumnWriteStore columnStore) {
            this.column.setColumnStore(columnStore);
        }
    }
}

