/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.acl;

import io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclAction;
import io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclScope;
import io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.acl.AclType;
import java.util.LinkedList;
import java.util.List;

public class AclEntry {
    public AclScope scope;
    public AclType type;
    public String name;
    public AclAction action;

    public AclEntry() {
    }

    public AclEntry(AclScope scope, AclType type, String name, AclAction action) {
        if (scope == null) {
            throw new IllegalArgumentException("AclScope is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("AclType is null");
        }
        if (type == AclType.MASK && name != null && !name.trim().equals("")) {
            throw new IllegalArgumentException("mask should not have user/group name");
        }
        if (type == AclType.OTHER && name != null && !name.trim().equals("")) {
            throw new IllegalArgumentException("ACL entry type 'other' should not have user/group name");
        }
        this.scope = scope;
        this.type = type;
        this.name = name;
        this.action = action;
    }

    public static AclEntry parseAclEntry(String entryString) throws IllegalArgumentException {
        return AclEntry.parseAclEntry(entryString, false);
    }

    public static AclEntry parseAclEntry(String entryString, boolean removeAcl) throws IllegalArgumentException {
        int fColonPos;
        if (entryString == null || entryString.equals("")) {
            return null;
        }
        AclEntry aclEntry = new AclEntry();
        String aclString = entryString.trim();
        String firstToken = aclString.substring(0, fColonPos = aclString.indexOf(":")).toLowerCase().trim();
        if (firstToken.equals("default")) {
            aclEntry.scope = AclScope.DEFAULT;
            aclString = aclString.substring(fColonPos + 1);
        } else {
            aclEntry.scope = AclScope.ACCESS;
        }
        String[] parts = aclString.split(":", 5);
        if (parts.length < 2 || parts.length > 3) {
            throw new IllegalArgumentException("invalid aclEntryString " + entryString);
        }
        if (parts.length == 2 && !removeAcl) {
            throw new IllegalArgumentException("invalid aclEntryString " + entryString);
        }
        try {
            aclEntry.type = AclType.valueOf(parts[0].toUpperCase().trim());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Invalid ACL AclType in " + entryString);
        }
        catch (NullPointerException ex) {
            throw new IllegalArgumentException("ACL Entry AclType missing in " + entryString);
        }
        aclEntry.name = parts[1].trim();
        if (aclEntry.type == AclType.MASK && !aclEntry.name.equals("")) {
            throw new IllegalArgumentException("mask entry cannot contain user/group name: " + entryString);
        }
        if (aclEntry.type == AclType.OTHER && !aclEntry.name.equals("")) {
            throw new IllegalArgumentException("entry of type 'other' should not contain user/group name: " + entryString);
        }
        if (!removeAcl) {
            try {
                aclEntry.action = AclAction.fromRwx(parts[2]);
            }
            catch (IllegalArgumentException ex) {
                throw new IllegalArgumentException("Invalid ACL action in " + entryString);
            }
            catch (NullPointerException ex) {
                throw new IllegalArgumentException("ACL action missing in " + entryString);
            }
        }
        return aclEntry;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean removeAcl) {
        StringBuilder str = new StringBuilder();
        if (this.scope == null) {
            throw new IllegalArgumentException("Acl Entry has no scope");
        }
        if (this.type == null) {
            throw new IllegalArgumentException("Acl Entry has no type");
        }
        if (this.scope == AclScope.DEFAULT) {
            str.append("default:");
        }
        str.append(this.type.toString().toLowerCase());
        str.append(":");
        if (this.name != null) {
            str.append(this.name);
        }
        if (this.action != null && !removeAcl) {
            str.append(":");
            str.append(this.action.toString());
        }
        return str.toString();
    }

    public static List<AclEntry> parseAclSpec(String aclString) throws IllegalArgumentException {
        String cdr;
        String car;
        if (aclString == null || aclString.trim().equals("")) {
            return new LinkedList<AclEntry>();
        }
        int commaPos = (aclString = aclString.trim()).indexOf(",");
        if (commaPos < 0) {
            car = aclString;
            cdr = null;
        } else {
            car = aclString.substring(0, commaPos).trim();
            cdr = aclString.substring(commaPos + 1);
        }
        LinkedList aclSpec = (LinkedList)AclEntry.parseAclSpec(cdr);
        if (!car.equals("")) {
            aclSpec.addFirst(AclEntry.parseAclEntry(car));
        }
        return aclSpec;
    }

    public static String aclListToString(List<AclEntry> list) {
        return AclEntry.aclListToString(list, false);
    }

    public static String aclListToString(List<AclEntry> list, boolean removeAcl) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String separator = "";
        StringBuilder output = new StringBuilder();
        for (AclEntry entry : list) {
            output.append(separator);
            output.append(entry.toString(removeAcl));
            separator = ",";
        }
        return output.toString();
    }
}

