/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies;

import io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies.RetryPolicy;

public class ExponentialBackoffPolicyforMSI
implements RetryPolicy {
    private int retryCount = 0;
    private int maxRetries = 4;
    private int exponentialRetryInterval = 1000;
    private int exponentialFactor = 4;
    private long lastAttemptStartTime = System.nanoTime();

    public ExponentialBackoffPolicyforMSI() {
    }

    public ExponentialBackoffPolicyforMSI(int maxRetries, int exponentialRetryInterval, int exponentialFactor) {
        this.maxRetries = maxRetries;
        this.exponentialRetryInterval = exponentialRetryInterval;
        this.exponentialFactor = exponentialFactor;
    }

    @Override
    public boolean shouldRetry(int httpResponseCode, Exception lastException) {
        if (httpResponseCode >= 300 && httpResponseCode < 500 && httpResponseCode != 404 && httpResponseCode != 408 && httpResponseCode != 429 && httpResponseCode != 401 || httpResponseCode == 501 || httpResponseCode == 505) {
            return false;
        }
        if (lastException != null || httpResponseCode >= 500 || httpResponseCode == 404 || httpResponseCode == 408 || httpResponseCode == 429 || httpResponseCode == 401) {
            if (this.retryCount < this.maxRetries) {
                int timeSpent = (int)((System.nanoTime() - this.lastAttemptStartTime) / 1000000L);
                this.wait(this.exponentialRetryInterval - timeSpent);
                this.exponentialRetryInterval *= this.exponentialFactor;
                ++this.retryCount;
                this.lastAttemptStartTime = System.nanoTime();
                return true;
            }
            return false;
        }
        if (httpResponseCode >= 100 && httpResponseCode < 300) {
            return false;
        }
        return false;
    }

    private void wait(int milliseconds) {
        if (milliseconds <= 0) {
            return;
        }
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

