/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies;

import io.prestosql.hadoop.$internal.com.microsoft.azure.datalake.store.retrypolicies.RetryPolicy;

public class NonIdempotentRetryPolicy
implements RetryPolicy {
    private int retryCount401 = 0;
    private int waitInterval = 100;
    private int retryCount429 = 0;
    private int maxRetries = 4;
    private int exponentialRetryInterval = 1000;
    private int exponentialFactor = 4;

    @Override
    public boolean shouldRetry(int httpResponseCode, Exception lastException) {
        if (httpResponseCode == 401 && this.retryCount401 == 0) {
            this.wait(this.waitInterval);
            ++this.retryCount401;
            return true;
        }
        if (httpResponseCode == 429) {
            if (this.retryCount429 < this.maxRetries) {
                this.wait(this.exponentialRetryInterval);
                this.exponentialRetryInterval *= this.exponentialFactor;
                ++this.retryCount429;
                return true;
            }
            return false;
        }
        return false;
    }

    private void wait(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }
}

