/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.com.microsoft.azure.storage.table;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum EdmType {
    NULL,
    BINARY,
    BOOLEAN,
    BYTE,
    DATE_TIME,
    DATE_TIME_OFFSET,
    DECIMAL,
    DOUBLE,
    SINGLE,
    GUID,
    INT16,
    INT32,
    INT64,
    SBYTE,
    STRING,
    TIME;

    private static final Set<EdmType> UNANNOTATED;

    protected final boolean mustAnnotateType() {
        return !UNANNOTATED.contains((Object)this);
    }

    public static EdmType parse(String value) {
        if (value == null || value.length() == 0) {
            return STRING;
        }
        if (value.equals("Edm.DateTime")) {
            return DATE_TIME;
        }
        if (value.equals("Edm.Int32")) {
            return INT32;
        }
        if (value.equals("Edm.Boolean")) {
            return BOOLEAN;
        }
        if (value.equals("Edm.Double")) {
            return DOUBLE;
        }
        if (value.equals("Edm.Int64")) {
            return INT64;
        }
        if (value.equals("Edm.Guid")) {
            return GUID;
        }
        if (value.equals("Edm.Binary")) {
            return BINARY;
        }
        throw new IllegalArgumentException(String.format("Invalid value '%s' for EdmType.", value));
    }

    public String toString() {
        if (this == BINARY) {
            return "Edm.Binary";
        }
        if (this == STRING) {
            return "Edm.String";
        }
        if (this == BOOLEAN) {
            return "Edm.Boolean";
        }
        if (this == DOUBLE) {
            return "Edm.Double";
        }
        if (this == GUID) {
            return "Edm.Guid";
        }
        if (this == INT32) {
            return "Edm.Int32";
        }
        if (this == INT64) {
            return "Edm.Int64";
        }
        if (this == DATE_TIME) {
            return "Edm.DateTime";
        }
        return "";
    }

    static {
        UNANNOTATED = Collections.unmodifiableSet(EnumSet.of(BOOLEAN, DOUBLE, INT32, STRING));
    }
}

