/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.avro.generic;

import io.prestosql.hadoop.$internal.org.apache.avro.AvroRuntimeException;
import io.prestosql.hadoop.$internal.org.apache.avro.Schema;
import io.prestosql.hadoop.$internal.org.apache.avro.generic.GenericArray;
import io.prestosql.hadoop.$internal.org.apache.avro.generic.GenericData;
import io.prestosql.hadoop.$internal.org.apache.avro.generic.GenericFixed;
import io.prestosql.hadoop.$internal.org.apache.avro.io.DatumReader;
import io.prestosql.hadoop.$internal.org.apache.avro.io.Decoder;
import io.prestosql.hadoop.$internal.org.apache.avro.io.DecoderFactory;
import io.prestosql.hadoop.$internal.org.apache.avro.io.ResolvingDecoder;
import io.prestosql.hadoop.$internal.org.apache.avro.util.Utf8;
import io.prestosql.hadoop.$internal.org.apache.avro.util.WeakIdentityHashMap;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public class GenericDatumReader<D>
implements DatumReader<D> {
    private final GenericData data;
    private Schema actual;
    private Schema expected;
    private ResolvingDecoder creatorResolver = null;
    private final Thread creator;
    private static final ThreadLocal<Map<Schema, Map<Schema, ResolvingDecoder>>> RESOLVER_CACHE = new ThreadLocal<Map<Schema, Map<Schema, ResolvingDecoder>>>(){

        @Override
        protected Map<Schema, Map<Schema, ResolvingDecoder>> initialValue() {
            return new WeakIdentityHashMap<Schema, Map<Schema, ResolvingDecoder>>();
        }
    };
    private Map<Schema, Class> stringClassCache = new IdentityHashMap<Schema, Class>();
    private final Map<Class, Constructor> stringCtorCache = new HashMap<Class, Constructor>();

    public GenericDatumReader() {
        this(null, null, GenericData.get());
    }

    public GenericDatumReader(Schema schema) {
        this(schema, schema, GenericData.get());
    }

    public GenericDatumReader(Schema writer, Schema reader) {
        this(writer, reader, GenericData.get());
    }

    public GenericDatumReader(Schema writer, Schema reader, GenericData data) {
        this(data);
        this.actual = writer;
        this.expected = reader;
    }

    protected GenericDatumReader(GenericData data) {
        this.data = data;
        this.creator = Thread.currentThread();
    }

    public GenericData getData() {
        return this.data;
    }

    public Schema getSchema() {
        return this.actual;
    }

    @Override
    public void setSchema(Schema writer) {
        this.actual = writer;
        if (this.expected == null) {
            this.expected = this.actual;
        }
        this.creatorResolver = null;
    }

    public Schema getExpected() {
        return this.expected;
    }

    public void setExpected(Schema reader) {
        this.expected = reader;
        this.creatorResolver = null;
    }

    protected final ResolvingDecoder getResolver(Schema actual, Schema expected) throws IOException {
        ResolvingDecoder resolver;
        Thread currThread = Thread.currentThread();
        if (currThread == this.creator && this.creatorResolver != null) {
            return this.creatorResolver;
        }
        Map<Schema, ResolvingDecoder> cache = RESOLVER_CACHE.get().get(actual);
        if (cache == null) {
            cache = new WeakIdentityHashMap<Schema, ResolvingDecoder>();
            RESOLVER_CACHE.get().put(actual, cache);
        }
        if ((resolver = cache.get(expected)) == null) {
            resolver = DecoderFactory.get().resolvingDecoder(Schema.applyAliases(actual, expected), expected, null);
            cache.put(expected, resolver);
        }
        if (currThread == this.creator) {
            this.creatorResolver = resolver;
        }
        return resolver;
    }

    @Override
    public D read(D reuse, Decoder in) throws IOException {
        ResolvingDecoder resolver = this.getResolver(this.actual, this.expected);
        resolver.configure(in);
        Object result = this.read(reuse, this.expected, resolver);
        resolver.drain();
        return (D)result;
    }

    protected Object read(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        switch (expected.getType()) {
            case RECORD: {
                return this.readRecord(old, expected, in);
            }
            case ENUM: {
                return this.readEnum(expected, in);
            }
            case ARRAY: {
                return this.readArray(old, expected, in);
            }
            case MAP: {
                return this.readMap(old, expected, in);
            }
            case UNION: {
                return this.read(old, expected.getTypes().get(in.readIndex()), in);
            }
            case FIXED: {
                return this.readFixed(old, expected, in);
            }
            case STRING: {
                return this.readString(old, expected, in);
            }
            case BYTES: {
                return this.readBytes(old, expected, in);
            }
            case INT: {
                return this.readInt(old, expected, in);
            }
            case LONG: {
                return in.readLong();
            }
            case FLOAT: {
                return Float.valueOf(in.readFloat());
            }
            case DOUBLE: {
                return in.readDouble();
            }
            case BOOLEAN: {
                return in.readBoolean();
            }
            case NULL: {
                in.readNull();
                return null;
            }
        }
        throw new AvroRuntimeException("Unknown type: " + expected);
    }

    protected Object readRecord(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Object r = this.data.newRecord(old, expected);
        Object state = this.data.getRecordState(r, expected);
        for (Schema.Field f : in.readFieldOrder()) {
            int pos = f.pos();
            String name = f.name();
            Object oldDatum = null;
            if (old != null) {
                oldDatum = this.data.getField(r, name, pos, state);
            }
            this.readField(r, f, oldDatum, in, state);
        }
        return r;
    }

    protected void readField(Object r, Schema.Field f, Object oldDatum, ResolvingDecoder in, Object state) throws IOException {
        this.data.setField(r, f.name(), f.pos(), this.read(oldDatum, f.schema(), in), state);
    }

    protected Object readEnum(Schema expected, Decoder in) throws IOException {
        return this.createEnum(expected.getEnumSymbols().get(in.readEnum()), expected);
    }

    protected Object createEnum(String symbol, Schema schema) {
        return this.data.createEnum(symbol, schema);
    }

    protected Object readArray(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Schema expectedType = expected.getElementType();
        long l = in.readArrayStart();
        long base = 0L;
        if (l > 0L) {
            Object array = this.newArray(old, (int)l, expected);
            do {
                for (long i = 0L; i < l; ++i) {
                    this.addToArray(array, base + i, this.read(this.peekArray(array), expectedType, in));
                }
                base += l;
            } while ((l = in.arrayNext()) > 0L);
            return array;
        }
        return this.newArray(old, 0, expected);
    }

    protected Object peekArray(Object array) {
        return array instanceof GenericArray ? ((GenericArray)array).peek() : null;
    }

    protected void addToArray(Object array, long pos, Object e) {
        ((Collection)array).add(e);
    }

    protected Object readMap(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Schema eValue = expected.getValueType();
        long l = in.readMapStart();
        Object map = this.newMap(old, (int)l);
        if (l > 0L) {
            do {
                int i = 0;
                while ((long)i < l) {
                    this.addToMap(map, this.readMapKey(null, expected, in), this.read(null, eValue, in));
                    ++i;
                }
            } while ((l = in.mapNext()) > 0L);
        }
        return map;
    }

    protected Object readMapKey(Object old, Schema expected, Decoder in) throws IOException {
        return this.readString(old, expected, in);
    }

    protected void addToMap(Object map, Object key, Object value) {
        ((Map)map).put(key, value);
    }

    protected Object readFixed(Object old, Schema expected, Decoder in) throws IOException {
        GenericFixed fixed = (GenericFixed)this.data.createFixed(old, expected);
        in.readFixed(fixed.bytes(), 0, expected.getFixedSize());
        return fixed;
    }

    @Deprecated
    protected Object createFixed(Object old, Schema schema) {
        return this.data.createFixed(old, schema);
    }

    @Deprecated
    protected Object createFixed(Object old, byte[] bytes, Schema schema) {
        return this.data.createFixed(old, bytes, schema);
    }

    @Deprecated
    protected Object newRecord(Object old, Schema schema) {
        return this.data.newRecord(old, schema);
    }

    protected Object newArray(Object old, int size, Schema schema) {
        if (old instanceof Collection) {
            ((Collection)old).clear();
            return old;
        }
        return new GenericData.Array(size, schema);
    }

    protected Object newMap(Object old, int size) {
        if (old instanceof Map) {
            ((Map)old).clear();
            return old;
        }
        return new HashMap(size);
    }

    protected Object readString(Object old, Schema expected, Decoder in) throws IOException {
        Class stringClass = this.getStringClass(expected);
        if (stringClass == String.class) {
            return in.readString();
        }
        if (stringClass == CharSequence.class) {
            return this.readString(old, in);
        }
        return this.newInstanceFromString(stringClass, in.readString());
    }

    protected Object readString(Object old, Decoder in) throws IOException {
        return in.readString(old instanceof Utf8 ? (Utf8)old : null);
    }

    protected Object createString(String value) {
        return new Utf8(value);
    }

    protected Class findStringClass(Schema schema) {
        String name = schema.getProp("avro.java.string");
        if (name == null) {
            return CharSequence.class;
        }
        switch (GenericData.StringType.valueOf(name)) {
            case String: {
                return String.class;
            }
        }
        return CharSequence.class;
    }

    private Class getStringClass(Schema s) {
        Class c = this.stringClassCache.get(s);
        if (c == null) {
            c = this.findStringClass(s);
            this.stringClassCache.put(s, c);
        }
        return c;
    }

    protected Object newInstanceFromString(Class c, String s) {
        try {
            Constructor ctor = this.stringCtorCache.get(c);
            if (ctor == null) {
                ctor = c.getDeclaredConstructor(String.class);
                ctor.setAccessible(true);
                this.stringCtorCache.put(c, ctor);
            }
            return ctor.newInstance(s);
        }
        catch (NoSuchMethodException e) {
            throw new AvroRuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new AvroRuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new AvroRuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new AvroRuntimeException(e);
        }
    }

    protected Object readBytes(Object old, Schema s, Decoder in) throws IOException {
        return this.readBytes(old, in);
    }

    protected Object readBytes(Object old, Decoder in) throws IOException {
        return in.readBytes(old instanceof ByteBuffer ? (ByteBuffer)old : null);
    }

    protected Object readInt(Object old, Schema expected, Decoder in) throws IOException {
        return in.readInt();
    }

    protected Object createBytes(byte[] value) {
        return ByteBuffer.wrap(value);
    }

    public static void skip(Schema schema, Decoder in) throws IOException {
        switch (schema.getType()) {
            case RECORD: {
                for (Schema.Field field : schema.getFields()) {
                    GenericDatumReader.skip(field.schema(), in);
                }
                break;
            }
            case ENUM: {
                in.readInt();
                break;
            }
            case ARRAY: {
                Schema elementType = schema.getElementType();
                long l = in.skipArray();
                while (l > 0L) {
                    for (long i = 0L; i < l; ++i) {
                        GenericDatumReader.skip(elementType, in);
                    }
                    l = in.skipArray();
                }
                break;
            }
            case MAP: {
                Schema value = schema.getValueType();
                long l = in.skipMap();
                while (l > 0L) {
                    for (long i = 0L; i < l; ++i) {
                        in.skipString();
                        GenericDatumReader.skip(value, in);
                    }
                    l = in.skipMap();
                }
                break;
            }
            case UNION: {
                GenericDatumReader.skip(schema.getTypes().get(in.readIndex()), in);
                break;
            }
            case FIXED: {
                in.skipFixed(schema.getFixedSize());
                break;
            }
            case STRING: {
                in.skipString();
                break;
            }
            case BYTES: {
                in.skipBytes();
                break;
            }
            case INT: {
                in.readInt();
                break;
            }
            case LONG: {
                in.readLong();
                break;
            }
            case FLOAT: {
                in.readFloat();
                break;
            }
            case DOUBLE: {
                in.readDouble();
                break;
            }
            case BOOLEAN: {
                in.readBoolean();
                break;
            }
            case NULL: {
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + schema);
            }
        }
    }
}

