/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.UniversalTag;
import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Simple;
import java.io.IOException;

public class Asn1BitString
extends Asn1Simple<byte[]> {
    private int padding;

    public Asn1BitString() {
        this((byte[])null);
    }

    public Asn1BitString(byte[] value) {
        this(value, 0);
    }

    public Asn1BitString(byte[] value, int padding) {
        super(UniversalTag.BIT_STRING, value);
        this.padding = padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public int getPadding() {
        return this.padding;
    }

    @Override
    protected int encodingBodyLength() {
        byte[] body = (byte[])this.getValue();
        if (body != null) {
            return body.length + 1;
        }
        return 0;
    }

    @Override
    protected void toBytes() {
        byte[] bytes = new byte[this.encodingBodyLength()];
        byte[] body = (byte[])this.getValue();
        if (body != null) {
            bytes[0] = (byte)this.padding;
            System.arraycopy(body, 0, bytes, 1, bytes.length - 1);
        }
        this.setBytes(bytes);
    }

    @Override
    protected void toValue() throws IOException {
        byte[] bytes = this.getBytes();
        if (bytes.length < 1) {
            throw new IOException("Bad stream, zero bytes found for bitstring");
        }
        byte paddingBits = bytes[0];
        this.validatePaddingBits(paddingBits);
        this.setPadding(paddingBits);
        byte[] newBytes = new byte[bytes.length - 1];
        if (bytes.length > 1) {
            System.arraycopy(bytes, 1, newBytes, 0, bytes.length - 1);
        }
        this.setValue(newBytes);
    }

    private void validatePaddingBits(int paddingBits) throws IOException {
        if (paddingBits < 0 || paddingBits > 7) {
            throw new IOException("Bad padding number: " + paddingBits + ", should be in [0, 7]");
        }
    }

    @Override
    public String toString() {
        String typeStr = this.tag().typeStr() + " [" + "tag=" + this.tag() + ", len=" + this.getHeaderLength() + "+" + this.getBodyLength() + "] ";
        byte[] valueBytes = (byte[])this.getValue();
        String valueStr = "<null>";
        if (valueBytes != null) {
            valueStr = "<" + valueBytes.length + " bytes>";
        }
        return typeStr + valueStr;
    }
}

