/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth;

import io.prestosql.hadoop.$internal.org.apache.kerby.KOptions;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.KrbContext;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.AbstractPreauthPlugin;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.KrbPreauth;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.PreauthContext;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.PreauthHandle;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.builtin.EncTsPreauth;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.builtin.TgtPreauth;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.pkinit.PkinitPreauth;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.token.TokenPreauth;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaData;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import java.util.ArrayList;
import java.util.List;

public class PreauthHandler {
    private KrbContext krbContext;
    private List<KrbPreauth> preauths;

    public void init(KrbContext krbContext) {
        this.krbContext = krbContext;
        this.loadPreauthPlugins(krbContext);
    }

    private void loadPreauthPlugins(KrbContext context) {
        this.preauths = new ArrayList<KrbPreauth>();
        AbstractPreauthPlugin preauth = new EncTsPreauth();
        preauth.init(context);
        this.preauths.add(preauth);
        preauth = new TgtPreauth();
        preauth.init(context);
        this.preauths.add(preauth);
        preauth = new PkinitPreauth();
        preauth.init(context);
        this.preauths.add(preauth);
        preauth = new TokenPreauth();
        preauth.init(context);
        this.preauths.add(preauth);
    }

    public PreauthContext preparePreauthContext(KdcRequest kdcRequest) {
        PreauthContext preauthContext = new PreauthContext();
        preauthContext.setPreauthRequired(this.krbContext.getConfig().isPreauthRequired());
        for (KrbPreauth preauth : this.preauths) {
            PreauthHandle handle = new PreauthHandle(preauth);
            handle.initRequestContext(kdcRequest);
            preauthContext.getHandles().add(handle);
        }
        return preauthContext;
    }

    public void preauth(KdcRequest kdcRequest) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        if (!preauthContext.isPreauthRequired()) {
            return;
        }
        this.setPreauthOptions(kdcRequest, kdcRequest.getPreauthOptions());
        if (!preauthContext.hasInputPaData()) {
            this.tryFirst(kdcRequest, preauthContext.getOutputPaData());
            return;
        }
        this.prepareUserResponses(kdcRequest, preauthContext.getInputPaData());
        preauthContext.getUserResponser().respondQuestions();
        if (!kdcRequest.isRetrying()) {
            this.process(kdcRequest, preauthContext.getInputPaData(), preauthContext.getOutputPaData());
        } else {
            this.tryAgain(kdcRequest, preauthContext.getInputPaData(), preauthContext.getOutputPaData());
        }
    }

    public void prepareUserResponses(KdcRequest kdcRequest, PaData inPadata) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PaDataEntry pae : inPadata.getElements()) {
            PreauthHandle handle;
            if (!preauthContext.isPaTypeAllowed(pae.getPaDataType()) || (handle = this.findHandle(kdcRequest, pae.getPaDataType())) == null) continue;
            handle.prepareQuestions(kdcRequest);
        }
    }

    public void setPreauthOptions(KdcRequest kdcRequest, KOptions preauthOptions) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PreauthHandle handle : preauthContext.getHandles()) {
            handle.setPreauthOptions(kdcRequest, preauthOptions);
        }
    }

    public void tryFirst(KdcRequest kdcRequest, PaData outPadata) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        PreauthHandle handle = this.findHandle(kdcRequest, preauthContext.getAllowedPaType());
        handle.tryFirst(kdcRequest, outPadata);
    }

    public void process(KdcRequest kdcRequest, PaData inPadata, PaData outPadata) throws KrbException {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (int real = 0; real <= 1; ++real) {
            for (PaDataEntry pae : inPadata.getElements()) {
                PreauthHandle handle;
                if (real > 0 && !preauthContext.isPaTypeAllowed(pae.getPaDataType()) || (handle = this.findHandle(kdcRequest, preauthContext.getAllowedPaType())) == null || real > 0 && preauthContext.checkAndPutTried(pae.getPaDataType())) continue;
                boolean gotData = handle.process(kdcRequest, pae, outPadata);
                if (real <= 0 || !gotData) continue;
                return;
            }
        }
    }

    public void tryAgain(KdcRequest kdcRequest, PaData inPadata, PaData outPadata) {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PaDataEntry pae : inPadata.getElements()) {
            PreauthHandle handle = this.findHandle(kdcRequest, pae.getPaDataType());
            if (handle == null) continue;
            handle.tryAgain(kdcRequest, pae.getPaDataType(), preauthContext.getErrorPaData(), outPadata);
        }
    }

    public void destroy() {
        for (KrbPreauth preauth : this.preauths) {
            preauth.destroy();
        }
    }

    private PreauthHandle findHandle(KdcRequest kdcRequest, PaDataType paType) {
        PreauthContext preauthContext = kdcRequest.getPreauthContext();
        for (PreauthHandle handle : preauthContext.getHandles()) {
            for (PaDataType pt : handle.preauth.getPaTypes()) {
                if (pt != paType) continue;
                return handle;
            }
        }
        return null;
    }
}

