/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.builtin;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbCodec;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.preauth.AbstractPreauthPlugin;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.client.request.KdcRequest;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.PaFlag;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.PaFlags;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.preauth.builtin.EncTsPreauthMeta;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaData;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataEntry;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaDataType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.pa.PaEncTsEnc;

public class EncTsPreauth
extends AbstractPreauthPlugin {
    public EncTsPreauth() {
        super(new EncTsPreauthMeta());
    }

    @Override
    public void prepareQuestions(KdcRequest kdcRequest, .PluginRequestContext requestContext) throws KrbException {
        kdcRequest.needAsKey();
    }

    @Override
    public void tryFirst(KdcRequest kdcRequest, .PluginRequestContext requestContext, PaData outPadata) throws KrbException {
        if (kdcRequest.getAsKey() == null) {
            kdcRequest.needAsKey();
        }
        outPadata.addElement(this.makeEntry(kdcRequest));
    }

    @Override
    public boolean process(KdcRequest kdcRequest, .PluginRequestContext requestContext, PaDataEntry inPadata, PaData outPadata) throws KrbException {
        if (kdcRequest.getAsKey() == null) {
            kdcRequest.needAsKey();
        }
        outPadata.addElement(this.makeEntry(kdcRequest));
        return true;
    }

    @Override
    public PaFlags getFlags(PaDataType paType) {
        PaFlags paFlags = new PaFlags(0);
        paFlags.setFlag(PaFlag.PA_REAL);
        return paFlags;
    }

    private PaDataEntry makeEntry(KdcRequest kdcRequest) throws KrbException {
        PaEncTsEnc paTs = new PaEncTsEnc();
        paTs.setPaTimestamp(kdcRequest.getPreauthTime());
        EncryptedData paDataValue = EncryptionUtil.seal(paTs, kdcRequest.getAsKey(), KeyUsage.AS_REQ_PA_ENC_TS);
        PaDataEntry tsPaEntry = new PaDataEntry();
        tsPaEntry.setPaDataType(PaDataType.ENC_TIMESTAMP);
        tsPaEntry.setPaDataValue(KrbCodec.encode(paDataValue));
        return tsPaEntry;
    }
}

