/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.common;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1Encodeable;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbCodec;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.CheckSumHandler;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.EncTypeHandler;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.CheckSum;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;

public class CheckSumUtil {
    public static CheckSum makeCheckSum(CheckSumType checkSumType, byte[] input) throws KrbException {
        return CheckSumHandler.checksum(checkSumType, input);
    }

    public static CheckSum makeCheckSumWithKey(CheckSumType checkSumType, byte[] input, EncryptionKey key, KeyUsage usage) throws KrbException {
        EncTypeHandler handler;
        if ((checkSumType == null || checkSumType == CheckSumType.NONE) && (checkSumType = (handler = EncryptionHandler.getEncHandler(key.getKeyType())).checksumType()) == null) {
            checkSumType = CheckSumType.CMAC_CAMELLIA128;
        }
        return CheckSumHandler.checksumWithKey(checkSumType, input, key.getKeyData(), usage);
    }

    public static CheckSum seal(Asn1Encodeable asn1Object, CheckSumType checkSumType) throws KrbException {
        byte[] encoded = KrbCodec.encode(asn1Object);
        CheckSum checksum = CheckSumUtil.makeCheckSum(checkSumType, encoded);
        return checksum;
    }

    public static CheckSum seal(Asn1Encodeable asn1Object, CheckSumType checkSumType, EncryptionKey key, KeyUsage usage) throws KrbException {
        byte[] encoded = KrbCodec.encode(asn1Object);
        CheckSum checksum = CheckSumUtil.makeCheckSumWithKey(checkSumType, encoded, key, usage);
        return checksum;
    }
}

