/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.common;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.NameType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;

public class KrbUtil {
    public static final String ANONYMOUS_PRINCIPAL = "ANONYMOUS@WELLKNOWN:ANONYMOUS";
    public static final String KRB5_WELLKNOWN_NAMESTR = "WELLKNOWN";
    public static final String KRB5_ANONYMOUS_PRINCSTR = "ANONYMOUS";
    public static final String KRB5_ANONYMOUS_REALMSTR = "WELLKNOWN:ANONYMOUS";

    public static PrincipalName makeTgsPrincipal(String realm) {
        String nameString = "krbtgt/" + realm + "@" + realm;
        return new PrincipalName(nameString, NameType.NT_SRV_INST);
    }

    public static PrincipalName makeKadminPrincipal(String realm) {
        String nameString = "kadmin/" + realm + "@" + realm;
        return new PrincipalName(nameString, NameType.NT_PRINCIPAL);
    }

    public static PrincipalName makeKadminPrincipal(String principal, String realm) {
        String nameString = principal + "@" + realm;
        return new PrincipalName(nameString, NameType.NT_PRINCIPAL);
    }

    public static boolean pricipalCompareIgnoreRealm(PrincipalName princ1, PrincipalName princ2) throws KrbException {
        if (princ1 != null && princ2 != null) {
            princ1.setRealm(null);
            princ2.setRealm(null);
            return princ1.getName().equals(princ2.getName());
        }
        throw new KrbException("principal can't be null.");
    }

    public static PrincipalName makeAnonymousPrincipal() {
        PrincipalName principalName = new PrincipalName("WELLKNOWN/ANONYMOUS");
        principalName.setRealm(KRB5_ANONYMOUS_REALMSTR);
        principalName.setNameType(NameType.NT_WELLKNOWN);
        return principalName;
    }
}

