/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.key;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.key.AbstractKeyMaker;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.util.Nfold;

public abstract class DkKeyMaker
extends AbstractKeyMaker {
    public DkKeyMaker(EncryptProvider encProvider) {
        super(encProvider);
    }

    public byte[] dk(byte[] key, byte[] constant) throws KrbException {
        return this.random2Key(this.dr(key, constant));
    }

    protected byte[] dr(byte[] key, byte[] constant) throws KrbException {
        byte[] ki;
        int blocksize = this.encProvider().blockSize();
        int keyInuptSize = this.encProvider().keyInputSize();
        byte[] keyBytes = new byte[keyInuptSize];
        if (constant.length != blocksize) {
            ki = Nfold.nfold(constant, blocksize);
        } else {
            ki = new byte[constant.length];
            System.arraycopy(constant, 0, ki, 0, constant.length);
        }
        for (int n = 0; n < keyInuptSize; n += blocksize) {
            this.encProvider().encrypt(key, ki);
            if (n + blocksize >= keyInuptSize) {
                System.arraycopy(ki, 0, keyBytes, n, keyInuptSize - n);
                break;
            }
            System.arraycopy(ki, 0, keyBytes, n, blocksize);
        }
        return keyBytes;
    }
}

