/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.util;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.enc.EncryptProvider;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.crypto.util.BytesUtil;
import java.util.Arrays;

public class Cmac {
    private static byte[] constRb = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -121};

    public static byte[] cmac(EncryptProvider encProvider, byte[] key, byte[] data, int outputSize) throws KrbException {
        return Cmac.cmac(encProvider, key, data, 0, data.length, outputSize);
    }

    public static byte[] cmac(EncryptProvider encProvider, byte[] key, byte[] data, int start, int len, int outputSize) throws KrbException {
        byte[] hash = Cmac.cmac(encProvider, key, data, start, len);
        if (hash.length > outputSize) {
            byte[] output = new byte[outputSize];
            System.arraycopy(hash, 0, output, 0, outputSize);
            return output;
        }
        return hash;
    }

    public static byte[] cmac(EncryptProvider encProvider, byte[] key, byte[] data) throws KrbException {
        return Cmac.cmac(encProvider, key, data, 0, data.length);
    }

    public static byte[] cmac(EncryptProvider encProvider, byte[] key, byte[] data, int start, int len) throws KrbException {
        boolean lastIsComplete;
        int blockSize = encProvider.blockSize();
        byte[] y = new byte[blockSize];
        byte[] mLast = new byte[blockSize];
        byte[] padded = new byte[blockSize];
        byte[] k1 = new byte[blockSize];
        byte[] k2 = new byte[blockSize];
        Cmac.makeSubkey(encProvider, key, k1, k2);
        int n = (len + blockSize - 1) / blockSize;
        if (n == 0) {
            n = 1;
            lastIsComplete = false;
        } else {
            lastIsComplete = len % blockSize == 0;
        }
        byte[] cipherState = new byte[blockSize];
        byte[] cipher = new byte[blockSize];
        for (int i = 0; i < n - 1; ++i) {
            System.arraycopy(data, i * blockSize, cipher, 0, blockSize);
            Cmac.encryptBlock(encProvider, key, cipherState, cipher);
            System.arraycopy(cipher, 0, cipherState, 0, blockSize);
        }
        System.arraycopy(cipher, 0, y, 0, blockSize);
        int lastPos = (n - 1) * blockSize;
        int lastLen = lastIsComplete ? blockSize : len % blockSize;
        byte[] lastBlock = new byte[lastLen];
        System.arraycopy(data, lastPos, lastBlock, 0, lastLen);
        if (lastIsComplete) {
            BytesUtil.xor(lastBlock, k1, mLast);
        } else {
            Cmac.padding(lastBlock, padded);
            BytesUtil.xor(padded, k2, mLast);
        }
        Cmac.encryptBlock(encProvider, key, cipherState, mLast);
        return mLast;
    }

    private static void makeSubkey(EncryptProvider encProvider, byte[] key, byte[] k1, byte[] k2) throws KrbException {
        byte[] tmp;
        byte[] l = new byte[k1.length];
        Arrays.fill(l, (byte)0);
        Cmac.encryptBlock(encProvider, key, null, l);
        if ((l[0] & 0x80) == 0) {
            Cmac.leftShiftByOne(l, k1);
        } else {
            tmp = new byte[k1.length];
            Cmac.leftShiftByOne(l, tmp);
            BytesUtil.xor(tmp, constRb, k1);
        }
        if ((k1[0] & 0x80) == 0) {
            Cmac.leftShiftByOne(k1, k2);
        } else {
            tmp = new byte[k1.length];
            Cmac.leftShiftByOne(k1, tmp);
            BytesUtil.xor(tmp, constRb, k2);
        }
    }

    private static void encryptBlock(EncryptProvider encProvider, byte[] key, byte[] cipherState, byte[] block) throws KrbException {
        if (cipherState == null) {
            cipherState = new byte[encProvider.blockSize()];
        }
        if (encProvider.supportCbcMac()) {
            encProvider.cbcMac(key, cipherState, block);
        } else {
            encProvider.encrypt(key, cipherState, block);
        }
    }

    private static void leftShiftByOne(byte[] input, byte[] output) {
        byte overflow = 0;
        for (int i = input.length - 1; i >= 0; --i) {
            output[i] = (byte)(input[i] << 1);
            int n = i;
            output[n] = (byte)(output[n] | overflow);
            overflow = (byte)((input[i] & 0x80) != 0 ? 1 : 0);
        }
    }

    private static void padding(byte[] data, byte[] padded) {
        int len = data.length;
        System.arraycopy(data, 0, padded, 0, len);
        padded[len] = -128;
        for (int i = len + 1; i < padded.length; ++i) {
            padded[i] = 0;
        }
    }
}

