/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.request;

import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbErrorCode;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.KrbException;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.common.EncryptionUtil;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.identity.KrbIdentity;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.KdcContext;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.request.KdcRequest;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.server.request.TgtTicketIssuer;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.KerberosTime;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.LastReq;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.LastReqEntry;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.LastReqType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.NameType;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.AsRep;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.AsReq;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.EncAsRepPart;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.EncKdcRepPart;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.kdc.KdcReq;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ticket.Ticket;
import io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type.ticket.TicketFlag;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;

public class AsRequest
extends KdcRequest {
    private static final Logger LOG = LoggerFactory.getLogger(AsRequest.class);

    public AsRequest(AsReq asReq, KdcContext kdcContext) {
        super(asReq, kdcContext);
    }

    @Override
    protected void checkClient() throws KrbException {
        KrbIdentity clientEntry;
        PrincipalName clientPrincipal;
        KdcReq request = this.getKdcReq();
        if (this.isToken()) {
            LOG.info("The request has a token with subject: " + this.getToken().getSubject());
            clientPrincipal = new PrincipalName(this.getToken().getSubject());
        } else {
            clientPrincipal = request.getReqBody().getCname();
        }
        if (clientPrincipal == null) {
            LOG.warn("Client principal name is null.");
            throw new KrbException(KrbErrorCode.KDC_ERR_C_PRINCIPAL_UNKNOWN);
        }
        String clientRealm = request.getReqBody().getRealm();
        if (clientRealm == null || clientRealm.isEmpty()) {
            clientRealm = this.getKdcContext().getKdcRealm();
        }
        clientPrincipal.setRealm(clientRealm);
        this.setClientPrincipal(clientPrincipal);
        if (this.isToken()) {
            clientEntry = new KrbIdentity(clientPrincipal.getName());
            clientEntry.setExpireTime(new KerberosTime(this.getToken().getExpiredTime().getTime()));
        } else {
            clientEntry = this.getEntry(clientPrincipal.getName());
        }
        if (clientEntry == null) {
            LOG.warn("Can't get the client entry.");
            throw new KrbException(KrbErrorCode.KDC_ERR_C_PRINCIPAL_UNKNOWN);
        }
        if (this.isAnonymous()) {
            clientEntry.setPrincipal(new PrincipalName(clientPrincipal.getName(), NameType.NT_WELLKNOWN));
        }
        this.setClientEntry(clientEntry);
        for (EncryptionType encType : request.getReqBody().getEtypes()) {
            if (!clientEntry.getKeys().containsKey(encType)) continue;
            EncryptionKey clientKey = clientEntry.getKeys().get(encType);
            this.setClientKey(clientKey);
            break;
        }
    }

    @Override
    protected void issueTicket() throws KrbException {
        TgtTicketIssuer issuer = new TgtTicketIssuer(this);
        Ticket newTicket = issuer.issueTicket();
        LOG.info("AS_REQ ISSUE: authtime " + newTicket.getEncPart().getAuthTime().getTime() + "," + newTicket.getEncPart().getCname() + " for " + newTicket.getSname());
        this.setTicket(newTicket);
    }

    @Override
    protected void makeReply() throws KrbException {
        Ticket ticket = this.getTicket();
        AsRep reply = new AsRep();
        reply.setTicket(ticket);
        reply.setCname(this.getClientEntry().getPrincipal());
        reply.setCrealm(this.getKdcContext().getKdcRealm());
        EncKdcRepPart encKdcRepPart = this.makeEncKdcRepPart();
        reply.setEncPart(encKdcRepPart);
        EncryptionKey clientKey = this.getClientKey();
        if (clientKey == null) {
            throw new KrbException("Cant't get the client key to encrypt the kdc rep part.");
        }
        EncryptedData encryptedData = EncryptionUtil.seal(encKdcRepPart, clientKey, KeyUsage.AS_REP_ENCPART);
        reply.setEncryptedEncPart(encryptedData);
        if (this.isPkinit()) {
            reply.setPaData(this.getPreauthContext().getOutputPaData());
        }
        this.setReply(reply);
    }

    protected EncKdcRepPart makeEncKdcRepPart() {
        KdcReq request = this.getKdcReq();
        Ticket ticket = this.getTicket();
        EncAsRepPart encKdcRepPart = new EncAsRepPart();
        encKdcRepPart.setKey(ticket.getEncPart().getKey());
        LastReq lastReq = new LastReq();
        LastReqEntry entry = new LastReqEntry();
        entry.setLrType(LastReqType.THE_LAST_INITIAL);
        entry.setLrValue(new KerberosTime());
        lastReq.add(entry);
        encKdcRepPart.setLastReq(lastReq);
        encKdcRepPart.setNonce(request.getReqBody().getNonce());
        encKdcRepPart.setFlags(ticket.getEncPart().getFlags());
        encKdcRepPart.setAuthTime(ticket.getEncPart().getAuthTime());
        encKdcRepPart.setStartTime(ticket.getEncPart().getStartTime());
        encKdcRepPart.setEndTime(ticket.getEncPart().getEndTime());
        if (ticket.getEncPart().getFlags().isFlagSet(TicketFlag.RENEWABLE)) {
            encKdcRepPart.setRenewTill(ticket.getEncPart().getRenewtill());
        }
        encKdcRepPart.setSname(ticket.getSname());
        encKdcRepPart.setSrealm(ticket.getRealm());
        encKdcRepPart.setCaddr(ticket.getEncPart().getClientAddresses());
        return encKdcRepPart;
    }
}

