/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop.$internal.org.apache.kerby.kerberos.kerb.type;

import io.prestosql.hadoop.$internal.org.apache.kerby.asn1.type.Asn1GeneralizedTime;
import java.util.Date;

public class KerberosTime
extends Asn1GeneralizedTime {
    public static final KerberosTime NEVER = new KerberosTime(Long.MAX_VALUE);
    public static final int MINUTE = 60000;
    public static final int DAY = 86400000;
    public static final int WEEK = 604800000;

    public KerberosTime() {
        super(System.currentTimeMillis() / 1000L * 1000L);
    }

    public KerberosTime(long time) {
        super(time);
    }

    public long getTime() {
        return ((Date)this.getValue()).getTime();
    }

    public void setTime(long time) {
        this.setValue(new Date(time));
    }

    public long getTimeInSeconds() {
        return this.getTime() / 1000L;
    }

    public boolean lessThan(KerberosTime ktime) {
        return ((Date)this.getValue()).compareTo((Date)ktime.getValue()) < 0;
    }

    public boolean lessThan(long time) {
        return ((Date)this.getValue()).getTime() < time;
    }

    public boolean greaterThan(KerberosTime ktime) {
        return ((Date)this.getValue()).compareTo((Date)ktime.getValue()) > 0;
    }

    public boolean isInClockSkew(long clockSkew) {
        long delta = Math.abs(this.getTime() - System.currentTimeMillis());
        return delta < clockSkew;
    }

    public KerberosTime copy() {
        long time = this.getTime();
        return new KerberosTime(time);
    }

    public KerberosTime extend(long duration) {
        long result = this.getTime() + duration;
        return new KerberosTime(result);
    }

    public long diff(KerberosTime kerberosTime) {
        return this.getTime() - kerberosTime.getTime();
    }

    public static KerberosTime now() {
        return new KerberosTime(System.currentTimeMillis());
    }

    public int hashCode() {
        return ((Date)this.getValue()).hashCode();
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof KerberosTime)) {
            return false;
        }
        return ((Date)this.getValue()).equals(((KerberosTime)that).getValue());
    }
}

