/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.hadoop;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.com.google.common.base.Strings;
import io.prestosql.hadoop.$internal.com.google.common.io.ByteArrayDataOutput;
import io.prestosql.hadoop.$internal.com.google.common.io.ByteStreams;
import io.prestosql.hadoop.$internal.com.google.common.net.HostAndPort;
import io.prestosql.hadoop.$internal.com.google.common.net.InetAddresses;
import io.prestosql.hadoop.ForwardingSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;

public class SocksSocketFactory
extends SocketFactory
implements Configurable {
    private Configuration conf;
    private HostAndPort proxy;

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        String server = conf.get("hadoop.socks.server");
        if (!Strings.isNullOrEmpty(server)) {
            this.proxy = HostAndPort.fromString(server);
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        Preconditions.checkState(this.proxy != null, "proxy was not configured");
        return SocksSocketFactory.createSocksSocket(this.proxy);
    }

    @Override
    public Socket createSocket(InetAddress addr, int port) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Socket createSocket(InetAddress addr, int port, InetAddress localHostAddr, int localPort) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Socket createSocket(String host, int port) {
        throw new UnsupportedOperationException("method not supported");
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHostAddr, int localPort) {
        throw new UnsupportedOperationException("method not supported");
    }

    private static Socket createSocksSocket(final HostAndPort proxy) throws IOException {
        return new ForwardingSocket(SocketChannel.open().socket()){

            @Override
            public SocketChannel getChannel() {
                return this.isConnected() ? super.getChannel() : null;
            }

            @Override
            public void connect(SocketAddress endpoint, int timeout) throws IOException {
                InetSocketAddress address;
                try {
                    address = new InetSocketAddress(InetAddress.getByName(proxy.getHostText()), proxy.getPort());
                    this.socket.connect(address, timeout);
                }
                catch (IOException e) {
                    throw new IOException("Failed to connect to proxy: " + proxy, e);
                }
                address = (InetSocketAddress)endpoint;
                String host = address.getAddress() != null ? InetAddresses.toAddrString(address.getAddress()) : address.getHostString();
                byte[] packet = SocksSocketFactory.createSocks4aPacket(host, address.getPort());
                this.socket.getOutputStream().write(packet);
                byte[] response = new byte[8];
                ByteStreams.readFully(this.socket.getInputStream(), response);
                if (response[1] != 90) {
                    throw new IOException(String.format("Invalid response from SOCKS server: 0x%02X", response[1]));
                }
            }
        };
    }

    private static byte[] createSocks4aPacket(String hostname, int port) {
        ByteArrayDataOutput buffer = ByteStreams.newDataOutput();
        buffer.writeByte(4);
        buffer.writeByte(1);
        buffer.writeShort(port);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(0);
        buffer.writeByte(1);
        buffer.writeByte(0);
        buffer.write(hostname.getBytes(StandardCharsets.US_ASCII));
        buffer.writeByte(0);
        return buffer.toByteArray();
    }
}

