/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MultipartUploader;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class MultipartUploaderFactory {
    public static final Logger LOG = LoggerFactory.getLogger(MultipartUploaderFactory.class);
    private static ServiceLoader<MultipartUploaderFactory> serviceLoader = ServiceLoader.load(MultipartUploaderFactory.class, MultipartUploaderFactory.class.getClassLoader());

    public static MultipartUploader get(FileSystem fs, Configuration conf) throws IOException {
        MultipartUploaderFactory factory;
        MultipartUploader mpu = null;
        Iterator<MultipartUploaderFactory> iterator = serviceLoader.iterator();
        while (iterator.hasNext() && (mpu = (factory = iterator.next()).createMultipartUploader(fs, conf)) == null) {
        }
        return mpu;
    }

    protected abstract MultipartUploader createMultipartUploader(FileSystem var1, Configuration var2) throws IOException;

    static {
        Iterator<MultipartUploaderFactory> iterServices = serviceLoader.iterator();
        while (iterServices.hasNext()) {
            iterServices.next();
        }
    }
}

