/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.oauth2;

import io.prestosql.hadoop.$internal.com.google.common.base.Preconditions;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADAuthenticator;
import org.apache.hadoop.fs.azurebfs.oauth2.AzureADToken;

public class ClientCredsTokenProvider
extends AccessTokenProvider {
    private final String authEndpoint;
    private final String clientId;
    private final String clientSecret;
    private static final Logger LOG = LoggerFactory.getLogger(AccessTokenProvider.class);

    public ClientCredsTokenProvider(String authEndpoint, String clientId, String clientSecret) {
        Preconditions.checkNotNull(authEndpoint, "authEndpoint");
        Preconditions.checkNotNull(clientId, "clientId");
        Preconditions.checkNotNull(clientSecret, "clientSecret");
        this.authEndpoint = authEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    protected AzureADToken refreshToken() throws IOException {
        LOG.debug("AADToken: refreshing client-credential based token");
        return AzureADAuthenticator.getTokenUsingClientCreds(this.authEndpoint, this.clientId, this.clientSecret);
    }
}

