/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.diskbalancer.connectors;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.ClusterConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.DBNameNodeConnector;
import org.apache.hadoop.hdfs.server.diskbalancer.connectors.JsonNodeConnector;

public final class ConnectorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConnectorFactory.class);

    public static ClusterConnector getCluster(URI clusterURI, Configuration conf) throws IOException, URISyntaxException {
        LOG.debug("Cluster URI : {}", (Object)clusterURI);
        LOG.debug("scheme : {}", (Object)clusterURI.getScheme());
        if (clusterURI.getScheme().startsWith("file")) {
            LOG.debug("Creating a JsonNodeConnector");
            return new JsonNodeConnector(clusterURI.toURL());
        }
        LOG.debug("Creating NameNode connector");
        return new DBNameNodeConnector(clusterURI, conf);
    }

    private ConnectorFactory() {
    }
}

