/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import io.prestosql.hadoop.$internal.org.apache.commons.text.StringEscapeUtils;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.FSImageLoader;
import org.apache.hadoop.hdfs.tools.offlineImageViewer.PBImageTextWriter;

public class PBImageDelimitedTextWriter
extends PBImageTextWriter {
    static final String DEFAULT_DELIMITER = "\t";
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final String delimiter;
    static final String CRLF = "\r\n";

    PBImageDelimitedTextWriter(PrintStream out, String delimiter, String tempPath) throws IOException {
        super(out, tempPath);
        this.delimiter = delimiter;
    }

    private String formatDate(long date) {
        return this.dateFormatter.format(new Date(date));
    }

    private void append(StringBuffer buffer, int field) {
        buffer.append(this.delimiter);
        buffer.append(field);
    }

    private void append(StringBuffer buffer, long field) {
        buffer.append(this.delimiter);
        buffer.append(field);
    }

    private void append(StringBuffer buffer, String field) {
        buffer.append(this.delimiter);
        String escapedField = StringEscapeUtils.escapeCsv(field);
        if (escapedField.contains(CRLF)) {
            escapedField = escapedField.replace(CRLF, "%x0D%x0A");
        } else if (escapedField.contains("\n")) {
            escapedField = escapedField.replace("\n", "%x0A");
        }
        buffer.append(escapedField);
    }

    @Override
    public String getEntry(String parent, FsImageProto.INodeSection.INode inode) {
        StringBuffer buffer = new StringBuffer();
        String inodeName = inode.getName().toStringUtf8();
        Path path = new Path(parent.isEmpty() ? "/" : parent, inodeName.isEmpty() ? "/" : inodeName);
        this.append(buffer, path.toString());
        PermissionStatus p = null;
        boolean isDir = false;
        boolean hasAcl = false;
        switch (inode.getType()) {
            case FILE: {
                FsImageProto.INodeSection.INodeFile file = inode.getFile();
                p = this.getPermission(file.getPermission());
                hasAcl = file.hasAcl() && file.getAcl().getEntriesCount() > 0;
                this.append(buffer, file.getReplication());
                this.append(buffer, this.formatDate(file.getModificationTime()));
                this.append(buffer, this.formatDate(file.getAccessTime()));
                this.append(buffer, file.getPreferredBlockSize());
                this.append(buffer, file.getBlocksCount());
                this.append(buffer, FSImageLoader.getFileSize(file));
                this.append(buffer, 0);
                this.append(buffer, 0);
                break;
            }
            case DIRECTORY: {
                FsImageProto.INodeSection.INodeDirectory dir = inode.getDirectory();
                p = this.getPermission(dir.getPermission());
                hasAcl = dir.hasAcl() && dir.getAcl().getEntriesCount() > 0;
                this.append(buffer, 0);
                this.append(buffer, this.formatDate(dir.getModificationTime()));
                this.append(buffer, this.formatDate(0L));
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, dir.getNsQuota());
                this.append(buffer, dir.getDsQuota());
                isDir = true;
                break;
            }
            case SYMLINK: {
                FsImageProto.INodeSection.INodeSymlink s = inode.getSymlink();
                p = this.getPermission(s.getPermission());
                this.append(buffer, 0);
                this.append(buffer, this.formatDate(s.getModificationTime()));
                this.append(buffer, this.formatDate(s.getAccessTime()));
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, 0);
                this.append(buffer, 0);
                break;
            }
        }
        assert (p != null);
        String dirString = isDir ? "d" : "-";
        String aclString = hasAcl ? "+" : "";
        this.append(buffer, dirString + p.getPermission().toString() + aclString);
        this.append(buffer, p.getUserName());
        this.append(buffer, p.getGroupName());
        return buffer.substring(1);
    }

    @Override
    public String getHeader() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Path");
        this.append(buffer, "Replication");
        this.append(buffer, "ModificationTime");
        this.append(buffer, "AccessTime");
        this.append(buffer, "PreferredBlockSize");
        this.append(buffer, "BlocksCount");
        this.append(buffer, "FileSize");
        this.append(buffer, "NSQUOTA");
        this.append(buffer, "DSQUOTA");
        this.append(buffer, "Permission");
        this.append(buffer, "UserName");
        this.append(buffer, "GroupName");
        return buffer.toString();
    }
}

