/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.split;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.hadoop.mapreduce.split.JobSplit;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JobSplitWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JobSplitWriter.class);
    private static final int splitVersion = 1;
    private static final byte[] SPLIT_FILE_HEADER;

    public static <T extends InputSplit> void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, List<InputSplit> splits) throws IOException, InterruptedException {
        InputSplit[] array = splits.toArray(new InputSplit[splits.size()]);
        JobSplitWriter.createSplitFiles((Path)jobSubmitDir, (Configuration)conf, (FileSystem)fs, (InputSplit[])array);
    }

    public static <T extends InputSplit> void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, T[] splits) throws IOException, InterruptedException {
        FSDataOutputStream out = JobSplitWriter.createFile(fs, JobSubmissionFiles.getJobSplitFile(jobSubmitDir), conf);
        JobSplit.SplitMetaInfo[] info = JobSplitWriter.writeNewSplits((Configuration)conf, splits, (FSDataOutputStream)out);
        out.close();
        JobSplitWriter.writeJobSplitMetaInfo(fs, JobSubmissionFiles.getJobSplitMetaFile(jobSubmitDir), new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION), 1, info);
    }

    public static void createSplitFiles(Path jobSubmitDir, Configuration conf, FileSystem fs, org.apache.hadoop.mapred.InputSplit[] splits) throws IOException {
        FSDataOutputStream out = JobSplitWriter.createFile(fs, JobSubmissionFiles.getJobSplitFile(jobSubmitDir), conf);
        JobSplit.SplitMetaInfo[] info = JobSplitWriter.writeOldSplits(splits, out, conf);
        out.close();
        JobSplitWriter.writeJobSplitMetaInfo(fs, JobSubmissionFiles.getJobSplitMetaFile(jobSubmitDir), new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION), 1, info);
    }

    private static FSDataOutputStream createFile(FileSystem fs, Path splitFile, Configuration job) throws IOException {
        FSDataOutputStream out = FileSystem.create(fs, splitFile, new FsPermission(JobSubmissionFiles.JOB_FILE_PERMISSION));
        int replication = job.getInt("mapreduce.client.submit.file.replication", 10);
        fs.setReplication(splitFile, (short)replication);
        JobSplitWriter.writeSplitHeader(out);
        return out;
    }

    private static void writeSplitHeader(FSDataOutputStream out) throws IOException {
        out.write(SPLIT_FILE_HEADER);
        out.writeInt(1);
    }

    private static <T extends InputSplit> JobSplit.SplitMetaInfo[] writeNewSplits(Configuration conf, T[] array, FSDataOutputStream out) throws IOException, InterruptedException {
        JobSplit.SplitMetaInfo[] info = new JobSplit.SplitMetaInfo[array.length];
        if (array.length != 0) {
            SerializationFactory factory = new SerializationFactory(conf);
            int i = 0;
            int maxBlockLocations = conf.getInt("mapreduce.job.max.split.locations", 15);
            long offset = out.getPos();
            for (T split : array) {
                long prevCount = out.getPos();
                Text.writeString(out, split.getClass().getName());
                Serializer<?> serializer = factory.getSerializer(split.getClass());
                serializer.open(out);
                serializer.serialize(split);
                long currCount = out.getPos();
                String[] locations = ((InputSplit)split).getLocations();
                if (locations.length > maxBlockLocations) {
                    LOG.warn("Max block location exceeded for split: " + split + " splitsize: " + locations.length + " maxsize: " + maxBlockLocations);
                    locations = Arrays.copyOf(locations, maxBlockLocations);
                }
                info[i++] = new JobSplit.SplitMetaInfo(locations, offset, ((InputSplit)split).getLength());
                offset += currCount - prevCount;
            }
        }
        return info;
    }

    private static JobSplit.SplitMetaInfo[] writeOldSplits(org.apache.hadoop.mapred.InputSplit[] splits, FSDataOutputStream out, Configuration conf) throws IOException {
        JobSplit.SplitMetaInfo[] info = new JobSplit.SplitMetaInfo[splits.length];
        if (splits.length != 0) {
            int i = 0;
            long offset = out.getPos();
            int maxBlockLocations = conf.getInt("mapreduce.job.max.split.locations", 15);
            for (org.apache.hadoop.mapred.InputSplit split : splits) {
                long prevLen = out.getPos();
                Text.writeString(out, split.getClass().getName());
                split.write(out);
                long currLen = out.getPos();
                String[] locations = split.getLocations();
                if (locations.length > maxBlockLocations) {
                    LOG.warn("Max block location exceeded for split: " + split + " splitsize: " + locations.length + " maxsize: " + maxBlockLocations);
                    locations = Arrays.copyOf(locations, maxBlockLocations);
                }
                info[i++] = new JobSplit.SplitMetaInfo(locations, offset, split.getLength());
                offset += currLen - prevLen;
            }
        }
        return info;
    }

    private static void writeJobSplitMetaInfo(FileSystem fs, Path filename, FsPermission p, int splitMetaInfoVersion, JobSplit.SplitMetaInfo[] allSplitMetaInfo) throws IOException {
        FSDataOutputStream out = FileSystem.create(fs, filename, p);
        out.write(JobSplit.META_SPLIT_FILE_HEADER);
        WritableUtils.writeVInt(out, splitMetaInfoVersion);
        WritableUtils.writeVInt(out, allSplitMetaInfo.length);
        for (JobSplit.SplitMetaInfo splitMetaInfo : allSplitMetaInfo) {
            splitMetaInfo.write(out);
        }
        out.close();
    }

    static {
        try {
            SPLIT_FILE_HEADER = "SPL".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException(u);
        }
    }
}

