/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation.web;

import io.prestosql.hadoop.;
import io.prestosql.hadoop.$internal.org.apache.http.NameValuePair;
import io.prestosql.hadoop.$internal.org.apache.http.client.utils.URLEncodedUtils;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.AuthenticationHandler;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.ZKDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.MultiSchemeDelegationTokenAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.PseudoDelegationTokenAuthenticationHandler;
import org.apache.hadoop.util.HttpExceptionUtils;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DelegationTokenAuthenticationFilter
extends AuthenticationFilter {
    private static final String APPLICATION_JSON_MIME = "application/json";
    private static final String ERROR_EXCEPTION_JSON = "exception";
    private static final String ERROR_MESSAGE_JSON = "message";
    private static final Logger LOG = LoggerFactory.getLogger(DelegationTokenAuthenticationFilter.class);
    public static final String DELEGATION_TOKEN_SECRET_MANAGER_ATTR = "hadoop.http.delegation-token-secret-manager";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final ThreadLocal<UserGroupInformation> UGI_TL = new ThreadLocal();
    public static final String PROXYUSER_PREFIX = "proxyuser";
    private SaslRpcServer.AuthMethod handlerAuthMethod;

    @Override
    protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
        Properties props = super.getConfiguration(configPrefix, filterConfig);
        this.setAuthHandlerClass(props);
        return props;
    }

    protected void setAuthHandlerClass(Properties props) throws ServletException {
        String authType = props.getProperty("type");
        if (authType == null) {
            throw new ServletException("Config property type doesn't exist");
        }
        if (authType.equals("simple")) {
            props.setProperty("type", PseudoDelegationTokenAuthenticationHandler.class.getName());
        } else if (authType.equals("kerberos")) {
            props.setProperty("type", KerberosDelegationTokenAuthenticationHandler.class.getName());
        } else if (authType.equals("multi-scheme")) {
            props.setProperty("type", MultiSchemeDelegationTokenAuthenticationHandler.class.getName());
        }
    }

    protected Configuration getProxyuserConfiguration(FilterConfig filterConfig) throws ServletException {
        Configuration conf = new Configuration(false);
        Enumeration names = filterConfig.getInitParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!name.startsWith("proxyuser.")) continue;
            String value = filterConfig.getInitParameter(name);
            conf.set(name, value);
        }
        return conf;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        AuthenticationHandler handler = this.getAuthenticationHandler();
        AbstractDelegationTokenSecretManager dtSecretManager = (AbstractDelegationTokenSecretManager)filterConfig.getServletContext().getAttribute(DELEGATION_TOKEN_SECRET_MANAGER_ATTR);
        if (dtSecretManager != null && handler instanceof DelegationTokenAuthenticationHandler) {
            DelegationTokenAuthenticationHandler dtHandler = (DelegationTokenAuthenticationHandler)this.getAuthenticationHandler();
            dtHandler.setExternalDelegationTokenSecretManager(dtSecretManager);
        }
        if (handler instanceof PseudoAuthenticationHandler || handler instanceof PseudoDelegationTokenAuthenticationHandler) {
            this.setHandlerAuthMethod(SaslRpcServer.AuthMethod.SIMPLE);
        }
        if (handler instanceof KerberosAuthenticationHandler || handler instanceof KerberosDelegationTokenAuthenticationHandler) {
            this.setHandlerAuthMethod(SaslRpcServer.AuthMethod.KERBEROS);
        }
        Configuration conf = this.getProxyuserConfiguration(filterConfig);
        ProxyUsers.refreshSuperUserGroupsConfiguration(conf, PROXYUSER_PREFIX);
    }

    @Override
    protected void initializeAuthHandler(String authHandlerClassName, FilterConfig filterConfig) throws ServletException {
        ZKDelegationTokenSecretManager.setCurator((CuratorFramework)filterConfig.getServletContext().getAttribute("signer.secret.provider.zookeeper.curator.client"));
        super.initializeAuthHandler(authHandlerClassName, filterConfig);
        ZKDelegationTokenSecretManager.setCurator(null);
    }

    protected void setHandlerAuthMethod(SaslRpcServer.AuthMethod authMethod) {
        this.handlerAuthMethod = authMethod;
    }

    @.VisibleForTesting
    static String getDoAs(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return null;
        }
        List<NameValuePair> list = URLEncodedUtils.parse(queryString, UTF8_CHARSET);
        if (list != null) {
            for (NameValuePair nv : list) {
                if (!"doAs".equalsIgnoreCase(nv.getName())) continue;
                return nv.getValue();
            }
        }
        return null;
    }

    static UserGroupInformation getHttpUserGroupInformationInContext() {
        return UGI_TL.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doFilter(FilterChain filterChain, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean requestCompleted = false;
        UserGroupInformation ugi = null;
        AuthenticationToken authToken = (AuthenticationToken)request.getUserPrincipal();
        if (authToken != null && authToken != AuthenticationToken.ANONYMOUS) {
            ugi = (UserGroupInformation)request.getAttribute("hadoop.security.delegation-token.ugi");
            if (ugi == null) {
                String realUser = request.getUserPrincipal().getName();
                ugi = UserGroupInformation.createRemoteUser(realUser, this.handlerAuthMethod);
                String doAsUser = DelegationTokenAuthenticationFilter.getDoAs(request);
                if (doAsUser != null) {
                    ugi = UserGroupInformation.createProxyUser(doAsUser, ugi);
                    try {
                        ProxyUsers.authorize(ugi, request.getRemoteAddr());
                    }
                    catch (AuthorizationException ex) {
                        HttpExceptionUtils.createServletExceptionResponse(response, 403, ex);
                        requestCompleted = true;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Authentication exception: " + ex.getMessage(), ex);
                        }
                        LOG.warn("Authentication exception: " + ex.getMessage());
                    }
                }
            }
            UGI_TL.set(ugi);
        }
        if (!requestCompleted) {
            final UserGroupInformation ugiF = ugi;
            try {
                request = new HttpServletRequestWrapper((HttpServletRequest)request){

                    public String getAuthType() {
                        return ugiF != null ? DelegationTokenAuthenticationFilter.this.handlerAuthMethod.toString() : null;
                    }

                    public String getRemoteUser() {
                        return ugiF != null ? ugiF.getShortUserName() : null;
                    }

                    public Principal getUserPrincipal() {
                        return ugiF != null ? new Principal(){

                            @Override
                            public String getName() {
                                return ugiF.getUserName();
                            }
                        } : null;
                    }
                };
                super.doFilter(filterChain, (HttpServletRequest)request, response);
            }
            finally {
                UGI_TL.remove();
            }
        }
    }
}

