/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.util.CacheableIPList;
import org.apache.hadoop.util.FileBasedIPList;
import org.apache.hadoop.util.IPList;

public class CombinedIPList
implements IPList {
    public static final Logger LOG = LoggerFactory.getLogger(CombinedIPList.class);
    private final IPList[] networkLists;

    public CombinedIPList(String fixedBlackListFile, String variableBlackListFile, long cacheExpiryInSeconds) {
        FileBasedIPList fixedNetworkList = new FileBasedIPList(fixedBlackListFile);
        if (variableBlackListFile != null) {
            CacheableIPList variableNetworkList = new CacheableIPList(new FileBasedIPList(variableBlackListFile), cacheExpiryInSeconds);
            this.networkLists = new IPList[]{fixedNetworkList, variableNetworkList};
        } else {
            this.networkLists = new IPList[]{fixedNetworkList};
        }
    }

    @Override
    public boolean isIn(String ipAddress) {
        if (ipAddress == null) {
            throw new IllegalArgumentException("ipAddress is null");
        }
        for (IPList networkList : this.networkLists) {
            if (!networkList.isIn(ipAddress)) continue;
            return true;
        }
        return false;
    }
}

