/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import io.prestosql.hadoop.$internal.com.google.common.base.Joiner;
import io.prestosql.hadoop.$internal.com.google.common.collect.Lists;
import io.prestosql.hadoop.$internal.com.google.common.collect.Maps;
import io.prestosql.hadoop.$internal.com.google.common.collect.Sets;
import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import io.prestosql.hadoop.$internal.org.slf4j.LoggerFactory;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.StopWatch;

@InterfaceAudience.Private
public class JvmPauseMonitor
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(JvmPauseMonitor.class);
    private static final long SLEEP_INTERVAL_MS = 500L;
    private long warnThresholdMs;
    private static final String WARN_THRESHOLD_KEY = "jvm.pause.warn-threshold.ms";
    private static final long WARN_THRESHOLD_DEFAULT = 10000L;
    private long infoThresholdMs;
    private static final String INFO_THRESHOLD_KEY = "jvm.pause.info-threshold.ms";
    private static final long INFO_THRESHOLD_DEFAULT = 1000L;
    private long numGcWarnThresholdExceeded = 0L;
    private long numGcInfoThresholdExceeded = 0L;
    private long totalGcExtraSleepTime = 0L;
    private Thread monitorThread;
    private volatile boolean shouldRun = true;

    public JvmPauseMonitor() {
        super(JvmPauseMonitor.class.getName());
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        this.warnThresholdMs = conf.getLong(WARN_THRESHOLD_KEY, 10000L);
        this.infoThresholdMs = conf.getLong(INFO_THRESHOLD_KEY, 1000L);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        this.monitorThread = new Daemon(new Monitor());
        this.monitorThread.start();
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        this.shouldRun = false;
        if (this.monitorThread != null) {
            this.monitorThread.interrupt();
            try {
                this.monitorThread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        super.serviceStop();
    }

    public boolean isStarted() {
        return this.monitorThread != null;
    }

    public long getNumGcWarnThresholdExceeded() {
        return this.numGcWarnThresholdExceeded;
    }

    public long getNumGcInfoThresholdExceeded() {
        return this.numGcInfoThresholdExceeded;
    }

    public long getTotalGcExtraSleepTime() {
        return this.totalGcExtraSleepTime;
    }

    private String formatMessage(long extraSleepTime, Map<String, GcTimes> gcTimesAfterSleep, Map<String, GcTimes> gcTimesBeforeSleep) {
        Sets.SetView<String> gcBeanNames = Sets.intersection(gcTimesAfterSleep.keySet(), gcTimesBeforeSleep.keySet());
        ArrayList<String> gcDiffs = Lists.newArrayList();
        for (String name : gcBeanNames) {
            GcTimes diff = gcTimesAfterSleep.get(name).subtract(gcTimesBeforeSleep.get(name));
            if (diff.gcCount == 0L) continue;
            gcDiffs.add("GC pool '" + name + "' had collection(s): " + diff.toString());
        }
        String ret = "Detected pause in JVM or host machine (eg GC): pause of approximately " + extraSleepTime + "ms\n";
        ret = gcDiffs.isEmpty() ? ret + "No GCs detected" : ret + Joiner.on("\n").join(gcDiffs);
        return ret;
    }

    private Map<String, GcTimes> getGcTimes() {
        HashMap<String, GcTimes> map = Maps.newHashMap();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            map.put(gcBean.getName(), new GcTimes(gcBean));
        }
        return map;
    }

    public static void main(String[] args) throws Exception {
        JvmPauseMonitor monitor = new JvmPauseMonitor();
        monitor.init(new Configuration());
        monitor.start();
        ArrayList<String> list = Lists.newArrayList();
        int i = 0;
        while (true) {
            list.add(String.valueOf(i++));
        }
    }

    private class Monitor
    implements Runnable {
        private Monitor() {
        }

        @Override
        public void run() {
            StopWatch sw = new StopWatch();
            Map gcTimesBeforeSleep = JvmPauseMonitor.this.getGcTimes();
            LOG.info("Starting JVM pause monitor");
            while (JvmPauseMonitor.this.shouldRun) {
                sw.reset().start();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ie) {
                    return;
                }
                long extraSleepTime = sw.now(TimeUnit.MILLISECONDS) - 500L;
                Map gcTimesAfterSleep = JvmPauseMonitor.this.getGcTimes();
                if (extraSleepTime > JvmPauseMonitor.this.warnThresholdMs) {
                    ++JvmPauseMonitor.this.numGcWarnThresholdExceeded;
                    LOG.warn(JvmPauseMonitor.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                } else if (extraSleepTime > JvmPauseMonitor.this.infoThresholdMs) {
                    ++JvmPauseMonitor.this.numGcInfoThresholdExceeded;
                    LOG.info(JvmPauseMonitor.this.formatMessage(extraSleepTime, gcTimesAfterSleep, gcTimesBeforeSleep));
                }
                JvmPauseMonitor.this.totalGcExtraSleepTime = JvmPauseMonitor.this.totalGcExtraSleepTime + extraSleepTime;
                gcTimesBeforeSleep = gcTimesAfterSleep;
            }
        }
    }

    private static class GcTimes {
        private long gcCount;
        private long gcTimeMillis;

        private GcTimes(GarbageCollectorMXBean gcBean) {
            this.gcCount = gcBean.getCollectionCount();
            this.gcTimeMillis = gcBean.getCollectionTime();
        }

        private GcTimes(long count, long time) {
            this.gcCount = count;
            this.gcTimeMillis = time;
        }

        private GcTimes subtract(GcTimes other) {
            return new GcTimes(this.gcCount - other.gcCount, this.gcTimeMillis - other.gcTimeMillis);
        }

        public String toString() {
            return "count=" + this.gcCount + " time=" + this.gcTimeMillis + "ms";
        }
    }
}

