/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util.concurrent;

import io.prestosql.hadoop.$internal.org.slf4j.Logger;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.util.concurrent.HadoopScheduledThreadPoolExecutor;
import org.apache.hadoop.util.concurrent.HadoopThreadPoolExecutor;

public final class HadoopExecutors {
    public static ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return new HadoopThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, ThreadFactory threadFactory) {
        return new HadoopThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static ExecutorService newFixedThreadPool(int nThreads) {
        return new HadoopThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    }

    public static ExecutorService newSingleThreadExecutor() {
        return Executors.newSingleThreadExecutor();
    }

    public static ExecutorService newSingleThreadExecutor(ThreadFactory threadFactory) {
        return Executors.newSingleThreadExecutor(threadFactory);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize) {
        return new HadoopScheduledThreadPoolExecutor(corePoolSize);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, ThreadFactory threadFactory) {
        return new HadoopScheduledThreadPoolExecutor(corePoolSize, threadFactory);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor() {
        return Executors.newSingleThreadScheduledExecutor();
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(ThreadFactory threadFactory) {
        return Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public static void shutdown(ExecutorService executorService, Logger logger, long timeout, TimeUnit unit) {
        block6: {
            try {
                if (executorService == null) break block6;
                executorService.shutdown();
                try {
                    if (!executorService.awaitTermination(timeout, unit)) {
                        executorService.shutdownNow();
                    }
                    if (!executorService.awaitTermination(timeout, unit)) {
                        logger.error("Unable to shutdown properly.");
                    }
                }
                catch (InterruptedException e) {
                    logger.error("Error attempting to shutdown.", e);
                    executorService.shutdownNow();
                }
            }
            catch (Exception e) {
                logger.error("Error during shutdown: ", e);
                throw e;
            }
        }
    }

    private HadoopExecutors() {
    }
}

