/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DataFilesTable;
import org.apache.iceberg.HistoryTable;
import org.apache.iceberg.ManifestEntriesTable;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SnapshotsTable;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.Transactions;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.CommitFailedException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMetastoreCatalog
implements Catalog {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMetastoreCatalog.class);

    public Table createTable(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        TableOperations ops = this.newTableOps(identifier);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table already exists: " + identifier, new Object[0]);
        }
        String baseLocation = location != null ? location : this.defaultWarehouseLocation(identifier);
        TableMetadata metadata = TableMetadata.newTableMetadata(ops, schema, spec, baseLocation, (Map<String, String>)(properties == null ? Maps.newHashMap() : properties));
        ops.commit(null, metadata);
        try {
            return new BaseTable(ops, identifier.toString());
        }
        catch (CommitFailedException ignored) {
            throw new AlreadyExistsException("Table was created concurrently: " + identifier, new Object[0]);
        }
    }

    public Transaction newCreateTableTransaction(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties) {
        TableOperations ops = this.newTableOps(identifier);
        if (ops.current() != null) {
            throw new AlreadyExistsException("Table already exists: " + identifier, new Object[0]);
        }
        String baseLocation = location != null ? location : this.defaultWarehouseLocation(identifier);
        HashMap tableProperties = properties != null ? properties : Maps.newHashMap();
        TableMetadata metadata = TableMetadata.newTableMetadata(ops, schema, spec, baseLocation, tableProperties);
        return Transactions.createTableTransaction(ops, metadata);
    }

    public Transaction newReplaceTableTransaction(TableIdentifier identifier, Schema schema, PartitionSpec spec, String location, Map<String, String> properties, boolean orCreate) {
        TableOperations ops = this.newTableOps(identifier);
        if (!orCreate && ops.current() == null) {
            throw new NoSuchTableException("No such table: " + identifier, new Object[0]);
        }
        String baseLocation = location != null ? location : this.defaultWarehouseLocation(identifier);
        HashMap tableProperties = properties != null ? properties : Maps.newHashMap();
        TableMetadata metadata = TableMetadata.newTableMetadata(ops, schema, spec, baseLocation, tableProperties);
        if (orCreate) {
            return Transactions.createOrReplaceTableTransaction(ops, metadata);
        }
        return Transactions.replaceTableTransaction(ops, metadata);
    }

    public Table loadTable(TableIdentifier identifier) {
        TableOperations ops = this.newTableOps(identifier);
        if (ops.current() == null) {
            String name = identifier.name();
            MetadataTableType type = MetadataTableType.from(name);
            if (type != null) {
                return this.loadMetadataTable(TableIdentifier.of((String[])identifier.namespace().levels()), type);
            }
            throw new NoSuchTableException("Table does not exist: " + identifier, new Object[0]);
        }
        return new BaseTable(ops, identifier.toString());
    }

    private Table loadMetadataTable(TableIdentifier identifier, MetadataTableType type) {
        TableOperations ops = this.newTableOps(identifier);
        if (ops.current() == null) {
            throw new NoSuchTableException("Table does not exist: " + identifier, new Object[0]);
        }
        BaseTable baseTable = new BaseTable(ops, identifier.toString());
        switch (type) {
            case ENTRIES: {
                return new ManifestEntriesTable(ops, baseTable);
            }
            case FILES: {
                return new DataFilesTable(ops, baseTable);
            }
            case HISTORY: {
                return new HistoryTable(ops, baseTable);
            }
            case SNAPSHOTS: {
                return new SnapshotsTable(ops, baseTable);
            }
            case MANIFESTS: {
                return new ManifestsTable(ops, baseTable);
            }
        }
        throw new NoSuchTableException(String.format("Unknown metadata table type: %s for %s", new Object[]{type, identifier}), new Object[0]);
    }

    protected abstract TableOperations newTableOps(TableIdentifier var1);

    protected abstract String defaultWarehouseLocation(TableIdentifier var1);

    protected static void dropTableData(FileIO io, TableMetadata metadata) {
        HashSet manifestListsToDelete = Sets.newHashSet();
        HashSet manifestsToDelete = Sets.newHashSet();
        for (Snapshot snapshot : metadata.snapshots()) {
            manifestsToDelete.addAll(snapshot.manifests());
            if (snapshot.manifestListLocation() == null) continue;
            manifestListsToDelete.add(snapshot.manifestListLocation());
        }
        LOG.info("Manifests to delete: {}", (Object)Joiner.on((String)", ").join((Iterable)manifestsToDelete));
        BaseMetastoreCatalog.deleteFiles(io, manifestsToDelete);
        Tasks.foreach(Iterables.transform((Iterable)manifestsToDelete, ManifestFile::path)).noRetry().suppressFailureWhenFinished().onFailure((manifest, exc) -> LOG.warn("Delete failed for manifest: {}", manifest, (Object)exc)).run(arg_0 -> ((FileIO)io).deleteFile(arg_0));
        Tasks.foreach(manifestListsToDelete).noRetry().suppressFailureWhenFinished().onFailure((list, exc) -> LOG.warn("Delete failed for manifest list: {}", list, (Object)exc)).run(arg_0 -> ((FileIO)io).deleteFile(arg_0));
        Tasks.foreach(metadata.file().location()).noRetry().suppressFailureWhenFinished().onFailure((list, exc) -> LOG.warn("Delete failed for metadata file: {}", list, (Object)exc)).run(arg_0 -> ((FileIO)io).deleteFile(arg_0));
    }

    private static void deleteFiles(FileIO io, Set<ManifestFile> allManifests) {
        ConcurrentMap deletedFiles = new MapMaker().concurrencyLevel(ThreadPools.WORKER_THREAD_POOL_SIZE).weakKeys().makeMap();
        Tasks.foreach(allManifests).noRetry().suppressFailureWhenFinished().executeWith(ThreadPools.getWorkerPool()).onFailure((item, exc) -> LOG.warn("Failed to get deleted files: this may cause orphaned data files", (Throwable)exc)).run(manifest -> {
            try (ManifestReader reader = ManifestReader.read(io.newInputFile(manifest.path()));){
                for (ManifestEntry entry : reader.entries()) {
                    String path = entry.file().path().toString().intern();
                    Boolean alreadyDeleted = deletedFiles.putIfAbsent(path, true);
                    if (alreadyDeleted != null && alreadyDeleted.booleanValue()) continue;
                    try {
                        io.deleteFile(path);
                    }
                    catch (RuntimeException e) {
                        LOG.warn("Delete failed for data file: {}", (Object)path, (Object)e);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Failed to read manifest file: " + manifest.path(), new Object[0]);
            }
        });
    }
}

