/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;

public class BaseOverwriteFiles
extends MergingSnapshotProducer<OverwriteFiles>
implements OverwriteFiles {
    private boolean validateAddedFilesMatchOverwriteFilter = false;
    private Long readSnapshotId = null;
    private Expression conflictDetectionFilter = null;

    protected BaseOverwriteFiles(TableOperations ops) {
        super(ops);
    }

    @Override
    protected OverwriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    public OverwriteFiles overwriteByRowFilter(Expression expr) {
        this.deleteByRowFilter(expr);
        return this;
    }

    public OverwriteFiles addFile(DataFile file) {
        this.add(file);
        return this;
    }

    public OverwriteFiles deleteFile(DataFile file) {
        this.delete(file);
        return this;
    }

    public OverwriteFiles validateAddedFilesMatchOverwriteFilter() {
        this.validateAddedFilesMatchOverwriteFilter = true;
        return this;
    }

    public OverwriteFiles validateNoConflictingAppends(Long newReadSnapshotId, Expression newConflictDetectionFilter) {
        Preconditions.checkArgument((newConflictDetectionFilter != null ? 1 : 0) != 0, (Object)"Conflict detection filter cannot be null");
        this.readSnapshotId = newReadSnapshotId;
        this.conflictDetectionFilter = newConflictDetectionFilter;
        this.failMissingDeletePaths();
        return this;
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base) {
        PartitionSpec spec;
        if (this.validateAddedFilesMatchOverwriteFilter) {
            spec = this.writeSpec();
            Expression rowFilter = this.rowFilter();
            Expression inclusiveExpr = Projections.inclusive((PartitionSpec)spec).project(rowFilter);
            Evaluator inclusive = new Evaluator(spec.partitionType(), inclusiveExpr);
            Expression strictExpr = Projections.strict((PartitionSpec)spec).project(rowFilter);
            Evaluator strict = new Evaluator(spec.partitionType(), strictExpr);
            StrictMetricsEvaluator metrics = new StrictMetricsEvaluator(base.schema(), rowFilter);
            for (DataFile file : this.addedFiles()) {
                ValidationException.check((inclusive.eval(file.partition()) && (strict.eval(file.partition()) || metrics.eval(file)) ? 1 : 0) != 0, (String)"Cannot append file with rows that do not match filter: %s: %s", (Object[])new Object[]{rowFilter, file.path()});
            }
        }
        if (this.conflictDetectionFilter != null) {
            spec = this.writeSpec();
            Expression inclusiveExpr = Projections.inclusive((PartitionSpec)spec).project(this.conflictDetectionFilter);
            Evaluator inclusive = new Evaluator(spec.partitionType(), inclusiveExpr);
            InclusiveMetricsEvaluator metrics = new InclusiveMetricsEvaluator(base.schema(), this.conflictDetectionFilter);
            List<DataFile> newFiles = this.collectNewFiles(base);
            for (DataFile newFile : newFiles) {
                ValidationException.check((!inclusive.eval(newFile.partition()) || !metrics.eval(newFile) ? 1 : 0) != 0, (String)"A file was appended that might contain data matching filter '%s': %s", (Object[])new Object[]{this.conflictDetectionFilter, newFile.path()});
            }
        }
        return super.apply(base);
    }

    private List<DataFile> collectNewFiles(TableMetadata meta) {
        Long currentSnapshotId;
        ArrayList<DataFile> newFiles = new ArrayList<DataFile>();
        Long l = currentSnapshotId = meta.currentSnapshot() == null ? null : Long.valueOf(meta.currentSnapshot().snapshotId());
        while (currentSnapshotId != null && !currentSnapshotId.equals(this.readSnapshotId)) {
            Snapshot currentSnapshot = meta.snapshot(currentSnapshotId);
            if (currentSnapshot == null) {
                throw new ValidationException("Cannot determine history between read snapshot %s and current %s", new Object[]{this.readSnapshotId, currentSnapshotId});
            }
            Iterables.addAll(newFiles, (Iterable)currentSnapshot.addedFiles());
            currentSnapshotId = currentSnapshot.parentId();
        }
        return newFiles;
    }
}

