/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Filterable;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.SnapshotProducer;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;

public class BaseRewriteManifests
extends SnapshotProducer<RewriteManifests>
implements RewriteManifests {
    private final TableOperations ops;
    private final PartitionSpec spec;
    private final long manifestTargetSizeBytes;
    private final List<ManifestFile> keptManifests = Collections.synchronizedList(new ArrayList());
    private final List<ManifestFile> newManifests = Collections.synchronizedList(new ArrayList());
    private final Set<ManifestFile> replacedManifests = Collections.synchronizedSet(new HashSet());
    private final Map<Object, WriterWrapper> writers = Collections.synchronizedMap(new HashMap());
    private final AtomicInteger manifestSuffix = new AtomicInteger(0);
    private final AtomicLong entryCount = new AtomicLong(0L);
    private final Map<String, String> summaryProps = new HashMap<String, String>();
    private Function<DataFile, Object> clusterByFunc;
    private Predicate<ManifestFile> predicate;
    private static final String REPLACED_CNT = "manifests-replaced";
    private static final String KEPT_CNT = "manifests-kept";
    private static final String NEW_CNT = "manifests-created";
    private static final String ENTRY_CNT = "entries-processed";

    BaseRewriteManifests(TableOperations ops) {
        super(ops);
        this.ops = ops;
        this.spec = ops.current().spec();
        this.manifestTargetSizeBytes = ops.current().propertyAsLong("commit.manifest.target-size-bytes", 0x800000L);
    }

    @Override
    protected RewriteManifests self() {
        return this;
    }

    @Override
    protected String operation() {
        return "replace";
    }

    public RewriteManifests set(String property, String value) {
        this.summaryProps.put(property, value);
        return this;
    }

    @Override
    protected Map<String, String> summary() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.summaryProps);
        result.put(KEPT_CNT, Integer.toString(this.keptManifests.size()));
        result.put(NEW_CNT, Integer.toString(this.newManifests.size()));
        result.put(REPLACED_CNT, Integer.toString(this.replacedManifests.size()));
        result.put(ENTRY_CNT, Long.toString(this.entryCount.get()));
        return result;
    }

    public RewriteManifests clusterBy(Function<DataFile, Object> func) {
        this.clusterByFunc = func;
        return this;
    }

    public RewriteManifests rewriteIf(Predicate<ManifestFile> pred) {
        this.predicate = pred;
        return this;
    }

    @Override
    public List<ManifestFile> apply(TableMetadata base) {
        Preconditions.checkNotNull(this.clusterByFunc, (Object)"clusterBy function cannot be null");
        List currentManifests = base.currentSnapshot().manifests();
        if (this.requiresRewrite(currentManifests)) {
            this.performRewrite(currentManifests);
        } else {
            this.addExistingFromNewCommit(currentManifests);
        }
        ArrayList<ManifestFile> apply = new ArrayList<ManifestFile>();
        apply.addAll(this.newManifests);
        apply.addAll(this.keptManifests);
        return apply;
    }

    private boolean requiresRewrite(List<ManifestFile> currentManifests) {
        if (this.replacedManifests.size() == 0) {
            return true;
        }
        HashSet set = Sets.newHashSet(currentManifests);
        return this.replacedManifests.stream().anyMatch(manifest -> !set.contains(manifest));
    }

    private void addExistingFromNewCommit(List<ManifestFile> currentManifests) {
        this.keptManifests.clear();
        currentManifests.stream().filter(manifest -> !this.replacedManifests.contains(manifest)).forEach(manifest -> this.keptManifests.add((ManifestFile)manifest));
    }

    private void reset() {
        this.cleanAll();
        this.entryCount.set(0L);
        this.keptManifests.clear();
        this.replacedManifests.clear();
        this.newManifests.clear();
        this.writers.clear();
    }

    private void performRewrite(List<ManifestFile> currentManifests) {
        this.reset();
        try {
            Tasks.foreach(currentManifests).executeWith(ThreadPools.getWorkerPool()).run(manifest -> {
                if (this.predicate != null && !this.predicate.test((ManifestFile)manifest)) {
                    this.keptManifests.add((ManifestFile)manifest);
                } else {
                    this.replacedManifests.add((ManifestFile)manifest);
                    try (ManifestReader reader = ManifestReader.read(this.ops.io().newInputFile(manifest.path()), this.ops.current()::spec);){
                        Filterable filteredManifest = reader.select(Arrays.asList("*"));
                        filteredManifest.liveEntries().forEach(entry -> this.appendEntry((ManifestEntry)entry, this.clusterByFunc.apply(entry.file())));
                    }
                    catch (IOException x) {
                        throw new RuntimeIOException(x);
                    }
                }
            });
        }
        finally {
            Tasks.foreach(this.writers.values()).executeWith(ThreadPools.getWorkerPool()).run(writer -> writer.close());
        }
    }

    private void appendEntry(ManifestEntry entry, Object key) {
        Preconditions.checkNotNull((Object)entry, (Object)"Manifest entry cannot be null");
        Preconditions.checkNotNull((Object)key, (Object)"Key cannot be null");
        WriterWrapper writer = this.getWriter(key);
        writer.addEntry(entry);
        this.entryCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WriterWrapper getWriter(Object key) {
        WriterWrapper writer = this.writers.get(key);
        if (writer == null) {
            Map<Object, WriterWrapper> map = this.writers;
            synchronized (map) {
                writer = this.writers.get(key);
                if (writer == null) {
                    writer = new WriterWrapper();
                    this.writers.put(key, writer);
                }
            }
        }
        return writer;
    }

    @Override
    protected void cleanUncommitted(Set<ManifestFile> committed) {
        for (ManifestFile manifest : this.newManifests) {
            if (committed.contains(manifest)) continue;
            this.deleteFile(manifest.path());
        }
    }

    long getManifestTargetSizeBytes() {
        return this.manifestTargetSizeBytes;
    }

    class WriterWrapper {
        private ManifestWriter writer;

        WriterWrapper() {
        }

        synchronized void addEntry(ManifestEntry entry) {
            if (this.writer == null) {
                this.writer = this.newWriter();
            } else if (this.writer.length() >= BaseRewriteManifests.this.getManifestTargetSizeBytes()) {
                this.close();
                this.writer = this.newWriter();
            }
            this.writer.existing(entry);
        }

        private ManifestWriter newWriter() {
            return new ManifestWriter(BaseRewriteManifests.this.spec, BaseRewriteManifests.this.manifestPath(BaseRewriteManifests.this.manifestSuffix.getAndIncrement()), BaseRewriteManifests.this.snapshotId());
        }

        synchronized void close() {
            if (this.writer != null) {
                try {
                    this.writer.close();
                    BaseRewriteManifests.this.newManifests.add(this.writer.toManifestFile());
                }
                catch (IOException x) {
                    throw new RuntimeIOException(x);
                }
            }
        }
    }
}

