/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SystemProperties;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ManifestEvaluator;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTableScan
extends BaseTableScan {
    private static final Logger LOG = LoggerFactory.getLogger(DataTableScan.class);
    private static final List<String> SCAN_COLUMNS = ImmutableList.of((Object)"snapshot_id", (Object)"file_path", (Object)"file_ordinal", (Object)"file_format", (Object)"block_size_in_bytes", (Object)"file_size_in_bytes", (Object)"record_count", (Object)"partition", (Object)"key_metadata");
    private static final List<String> SCAN_WITH_STATS_COLUMNS = ImmutableList.builder().addAll(SCAN_COLUMNS).add((Object[])new String[]{"value_counts", "null_value_counts", "lower_bounds", "upper_bounds", "column_sizes"}).build();
    private static final boolean PLAN_SCANS_WITH_WORKER_POOL = SystemProperties.getBoolean("iceberg.scan.plan-in-worker-pool", true);

    public DataTableScan(TableOperations ops, Table table) {
        super(ops, table, table.schema());
    }

    protected DataTableScan(TableOperations ops, Table table, Long snapshotId, Schema schema, Expression rowFilter, boolean caseSensitive, boolean colStats, Collection<String> selectedColumns, ImmutableMap<String, String> options) {
        super(ops, table, snapshotId, schema, rowFilter, caseSensitive, colStats, selectedColumns, options);
    }

    @Override
    protected TableScan newRefinedScan(TableOperations ops, Table table, Long snapshotId, Schema schema, Expression rowFilter, boolean caseSensitive, boolean colStats, Collection<String> selectedColumns, ImmutableMap<String, String> options) {
        return new DataTableScan(ops, table, snapshotId, schema, rowFilter, caseSensitive, colStats, selectedColumns, options);
    }

    @Override
    public CloseableIterable<FileScanTask> planFiles(TableOperations ops, Snapshot snapshot, Expression rowFilter, boolean caseSensitive, boolean colStats) {
        LoadingCache evalCache = Caffeine.newBuilder().build(specId -> {
            PartitionSpec spec = ops.current().spec((int)specId);
            return ManifestEvaluator.forRowFilter((Expression)rowFilter, (PartitionSpec)spec, (boolean)caseSensitive);
        });
        Iterable nonEmptyManifests = Iterables.filter((Iterable)snapshot.manifests(), manifest -> manifest.hasAddedFiles() || manifest.hasExistingFiles());
        Iterable matchingManifests = Iterables.filter((Iterable)nonEmptyManifests, manifest -> ((ManifestEvaluator)evalCache.get((Object)manifest.partitionSpecId())).eval(manifest));
        Iterable readers = Iterables.transform((Iterable)matchingManifests, manifest -> {
            ManifestReader reader = ManifestReader.read(ops.io().newInputFile(manifest.path()), ops.current()::spec);
            PartitionSpec spec = ops.current().spec(manifest.partitionSpecId());
            String schemaString = SchemaParser.toJson(spec.schema());
            String specString = PartitionSpecParser.toJson(spec);
            ResidualEvaluator residuals = ResidualEvaluator.of((PartitionSpec)spec, (Expression)rowFilter, (boolean)caseSensitive);
            return CloseableIterable.transform((CloseableIterable)reader.filterRows(rowFilter).caseSensitive(caseSensitive).select(colStats ? SCAN_WITH_STATS_COLUMNS : SCAN_COLUMNS), file -> new BaseFileScanTask((DataFile)file, schemaString, specString, residuals));
        });
        if (PLAN_SCANS_WITH_WORKER_POOL && snapshot.manifests().size() > 1) {
            return new ParallelIterable<FileScanTask>(readers, ThreadPools.getWorkerPool());
        }
        return CloseableIterable.concat((Iterable)readers);
    }

    @Override
    protected long targetSplitSize(TableOperations ops) {
        return ops.current().propertyAsLong("read.split.target-size", 0x8000000L);
    }
}

