/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.Filterable;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.InclusiveMetricsEvaluator;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.io.CloseableIterable;

public class FilteredManifest
implements Filterable<FilteredManifest> {
    private static final Set<String> STATS_COLUMNS = Sets.newHashSet((Object[])new String[]{"value_counts", "null_value_counts", "lower_bounds", "upper_bounds"});
    private final ManifestReader reader;
    private final Expression partFilter;
    private final Expression rowFilter;
    private final Schema fileSchema;
    private final Collection<String> columns;
    private final boolean caseSensitive;
    private Evaluator lazyEvaluator = null;
    private InclusiveMetricsEvaluator lazyMetricsEvaluator = null;

    FilteredManifest(ManifestReader reader, Expression partFilter, Expression rowFilter, Schema fileSchema, Collection<String> columns, boolean caseSensitive) {
        Preconditions.checkNotNull((Object)((Object)reader), (Object)"ManifestReader cannot be null");
        this.reader = reader;
        this.partFilter = partFilter;
        this.rowFilter = rowFilter;
        this.fileSchema = fileSchema;
        this.columns = columns;
        this.caseSensitive = caseSensitive;
    }

    public FilteredManifest select(Collection<String> selectedColumns) {
        return new FilteredManifest(this.reader, this.partFilter, this.rowFilter, this.fileSchema, selectedColumns, this.caseSensitive);
    }

    public FilteredManifest project(Schema fileProjection) {
        return new FilteredManifest(this.reader, this.partFilter, this.rowFilter, fileProjection, this.columns, this.caseSensitive);
    }

    public FilteredManifest filterPartitions(Expression expr) {
        return new FilteredManifest(this.reader, Expressions.and((Expression)this.partFilter, (Expression)expr), this.rowFilter, this.fileSchema, this.columns, this.caseSensitive);
    }

    public FilteredManifest filterRows(Expression expr) {
        return new FilteredManifest(this.reader, this.partFilter, Expressions.and((Expression)this.rowFilter, (Expression)expr), this.fileSchema, this.columns, this.caseSensitive);
    }

    public FilteredManifest caseSensitive(boolean isCaseSensitive) {
        return new FilteredManifest(this.reader, this.partFilter, this.rowFilter, this.fileSchema, this.columns, isCaseSensitive);
    }

    CloseableIterable<ManifestEntry> allEntries() {
        if (this.rowFilter != null && this.rowFilter != Expressions.alwaysTrue() || this.partFilter != null && this.partFilter != Expressions.alwaysTrue()) {
            Evaluator evaluator = this.evaluator();
            InclusiveMetricsEvaluator metricsEvaluator = this.metricsEvaluator();
            return CloseableIterable.filter(this.reader.entries(FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive)), entry -> entry != null && evaluator.eval(entry.file().partition()) && metricsEvaluator.eval(entry.file()));
        }
        return this.reader.entries(FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive));
    }

    CloseableIterable<ManifestEntry> liveEntries() {
        if (this.rowFilter != null && this.rowFilter != Expressions.alwaysTrue() || this.partFilter != null && this.partFilter != Expressions.alwaysTrue()) {
            Evaluator evaluator = this.evaluator();
            InclusiveMetricsEvaluator metricsEvaluator = this.metricsEvaluator();
            return CloseableIterable.filter(this.reader.entries(FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive)), entry -> entry != null && entry.status() != ManifestEntry.Status.DELETED && evaluator.eval(entry.file().partition()) && metricsEvaluator.eval(entry.file()));
        }
        return CloseableIterable.filter(this.reader.entries(FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive)), entry -> entry != null && entry.status() != ManifestEntry.Status.DELETED);
    }

    public Iterator<DataFile> iterator() {
        if (this.rowFilter != null && this.rowFilter != Expressions.alwaysTrue() || this.partFilter != null && this.partFilter != Expressions.alwaysTrue()) {
            Evaluator evaluator = this.evaluator();
            InclusiveMetricsEvaluator metricsEvaluator = this.metricsEvaluator();
            ArrayList projectColumns = Lists.newArrayList(this.columns);
            projectColumns.addAll(STATS_COLUMNS);
            boolean dropStats = Sets.intersection((Set)Sets.newHashSet(this.columns), STATS_COLUMNS).isEmpty();
            return Iterators.transform((Iterator)Iterators.filter(this.reader.iterator(this.partFilter, FilteredManifest.projection(this.fileSchema, projectColumns, this.caseSensitive)), input -> input != null && evaluator.eval(input.partition()) && metricsEvaluator.eval(input)), (Function)(dropStats ? DataFile::copyWithoutStats : DataFile::copy));
        }
        return Iterators.transform(this.reader.iterator(this.partFilter, FilteredManifest.projection(this.fileSchema, this.columns, this.caseSensitive)), DataFile::copy);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private static Schema projection(Schema fileSchema, Collection<String> columns, boolean caseSensitive) {
        if (columns != null) {
            if (caseSensitive) {
                return fileSchema.select(columns);
            }
            return fileSchema.caseInsensitiveSelect(columns);
        }
        return fileSchema;
    }

    private Evaluator evaluator() {
        if (this.lazyEvaluator == null) {
            Expression projected = Projections.inclusive((PartitionSpec)this.reader.spec(), (boolean)this.caseSensitive).project(this.rowFilter);
            Expression finalPartFilter = Expressions.and((Expression)projected, (Expression)this.partFilter);
            this.lazyEvaluator = finalPartFilter != null ? new Evaluator(this.reader.spec().partitionType(), finalPartFilter, this.caseSensitive) : new Evaluator(this.reader.spec().partitionType(), (Expression)Expressions.alwaysTrue(), this.caseSensitive);
        }
        return this.lazyEvaluator;
    }

    private InclusiveMetricsEvaluator metricsEvaluator() {
        if (this.lazyMetricsEvaluator == null) {
            this.lazyMetricsEvaluator = this.rowFilter != null ? new InclusiveMetricsEvaluator(this.reader.spec().schema(), this.rowFilter, this.caseSensitive) : new InclusiveMetricsEvaluator(this.reader.spec().schema(), (Expression)Expressions.alwaysTrue(), this.caseSensitive);
        }
        return this.lazyMetricsEvaluator;
    }
}

