/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ByteBuffers;

public class GenericPartitionFieldSummary
implements ManifestFile.PartitionFieldSummary,
StructLike,
IndexedRecord,
SpecificData.SchemaConstructable,
Serializable {
    private static final Schema AVRO_SCHEMA = AvroSchemaUtil.convert((Type)ManifestFile.PartitionFieldSummary.getType());
    private transient Schema avroSchema;
    private int[] fromProjectionPos;
    private boolean containsNull = false;
    private ByteBuffer lowerBound = null;
    private ByteBuffer upperBound = null;

    public GenericPartitionFieldSummary(Schema avroSchema) {
        this.avroSchema = avroSchema;
        List fields = AvroSchemaUtil.convert(avroSchema).asNestedType().asStructType().fields();
        List allFields = ManifestFile.PartitionFieldSummary.getType().fields();
        this.fromProjectionPos = new int[fields.size()];
        for (int i = 0; i < this.fromProjectionPos.length; ++i) {
            boolean found = false;
            for (int j = 0; j < allFields.size(); ++j) {
                if (((Types.NestedField)fields.get(i)).fieldId() != ((Types.NestedField)allFields.get(j)).fieldId()) continue;
                found = true;
                this.fromProjectionPos[i] = j;
            }
            if (found) continue;
            throw new IllegalArgumentException("Cannot find projected field: " + fields.get(i));
        }
    }

    public GenericPartitionFieldSummary(boolean containsNull, ByteBuffer lowerBound, ByteBuffer upperBound) {
        this.avroSchema = AVRO_SCHEMA;
        this.containsNull = containsNull;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.fromProjectionPos = null;
    }

    private GenericPartitionFieldSummary(GenericPartitionFieldSummary toCopy) {
        this.avroSchema = toCopy.avroSchema;
        this.containsNull = toCopy.containsNull;
        this.lowerBound = ByteBuffers.copy(toCopy.lowerBound);
        this.upperBound = ByteBuffers.copy(toCopy.upperBound);
        this.fromProjectionPos = toCopy.fromProjectionPos;
    }

    GenericPartitionFieldSummary() {
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public ByteBuffer lowerBound() {
        return this.lowerBound;
    }

    public ByteBuffer upperBound() {
        return this.upperBound;
    }

    public int size() {
        return ManifestFile.PartitionFieldSummary.getType().fields().size();
    }

    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.get(pos));
    }

    public Object get(int i) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                return this.containsNull;
            }
            case 1: {
                return this.lowerBound;
            }
            case 2: {
                return this.upperBound;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + pos);
    }

    public <T> void set(int i, T value) {
        int pos = i;
        if (this.fromProjectionPos != null) {
            pos = this.fromProjectionPos[i];
        }
        switch (pos) {
            case 0: {
                this.containsNull = (Boolean)value;
                return;
            }
            case 1: {
                this.lowerBound = (ByteBuffer)value;
                return;
            }
            case 2: {
                this.upperBound = (ByteBuffer)value;
                return;
            }
        }
    }

    public void put(int i, Object v) {
        this.set(i, v);
    }

    public ManifestFile.PartitionFieldSummary copy() {
        return new GenericPartitionFieldSummary(this);
    }

    public Schema getSchema() {
        return this.avroSchema;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("contains_null", this.containsNull).add("lower_bound", (Object)this.lowerBound).add("upper_bound", (Object)this.upperBound).toString();
    }
}

