/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Filterable;
import org.apache.iceberg.FilteredManifest;
import org.apache.iceberg.GenericDataFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.PartitionData;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestReader
extends CloseableGroup
implements Filterable<FilteredManifest> {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestReader.class);
    private static final List<String> ALL_COLUMNS = ImmutableList.of((Object)"*");
    static final List<String> CHANGE_COLUMNS = ImmutableList.of((Object)"file_path", (Object)"file_format", (Object)"partition", (Object)"record_count", (Object)"file_size_in_bytes");
    static final List<String> CHANGE_WITH_STATS_COLUMNS = ImmutableList.builder().addAll(CHANGE_COLUMNS).add((Object[])new String[]{"value_counts", "null_value_counts", "lower_bounds", "upper_bounds"}).build();
    private final InputFile file;
    private final Map<String, String> metadata;
    private final PartitionSpec spec;
    private final Schema fileSchema;
    private List<ManifestEntry> cachedAdds = null;
    private List<ManifestEntry> cachedDeletes = null;

    public static ManifestReader read(InputFile file) {
        return new ManifestReader(file, null);
    }

    public static ManifestReader read(InputFile file, Function<Integer, PartitionSpec> specLookup) {
        return new ManifestReader(file, specLookup);
    }

    private ManifestReader(InputFile file, Function<Integer, PartitionSpec> specLookup) {
        this.file = file;
        try (AvroIterable headerReader = Avro.read(file).project(ManifestEntry.getSchema(Types.StructType.of((Types.NestedField[])new Types.NestedField[0])).select(new String[]{"status"})).build();){
            this.metadata = headerReader.getMetadata();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        int specId = 0;
        String specProperty = this.metadata.get("partition-spec-id");
        if (specProperty != null) {
            specId = Integer.parseInt(specProperty);
        }
        if (specLookup != null) {
            this.spec = specLookup.apply(specId);
        } else {
            Schema schema = SchemaParser.fromJson(this.metadata.get("schema"));
            this.spec = PartitionSpecParser.fromJsonFields(schema, specId, this.metadata.get("partition-spec"));
        }
        this.fileSchema = new Schema(DataFile.getType((Types.StructType)this.spec.partitionType()).fields());
    }

    public InputFile file() {
        return this.file;
    }

    public Schema schema() {
        return this.fileSchema;
    }

    public PartitionSpec spec() {
        return this.spec;
    }

    public FilteredManifest select(Collection<String> columns) {
        return new FilteredManifest(this, (Expression)Expressions.alwaysTrue(), (Expression)Expressions.alwaysTrue(), this.fileSchema, columns, true);
    }

    public FilteredManifest project(Schema fileProjection) {
        return new FilteredManifest(this, (Expression)Expressions.alwaysTrue(), (Expression)Expressions.alwaysTrue(), fileProjection, ALL_COLUMNS, true);
    }

    public FilteredManifest filterPartitions(Expression expr) {
        return new FilteredManifest(this, expr, (Expression)Expressions.alwaysTrue(), this.fileSchema, ALL_COLUMNS, true);
    }

    public FilteredManifest filterRows(Expression expr) {
        return new FilteredManifest(this, (Expression)Expressions.alwaysTrue(), expr, this.fileSchema, ALL_COLUMNS, true);
    }

    public FilteredManifest caseSensitive(boolean caseSensitive) {
        return new FilteredManifest(this, (Expression)Expressions.alwaysTrue(), (Expression)Expressions.alwaysTrue(), this.fileSchema, ALL_COLUMNS, caseSensitive);
    }

    public List<ManifestEntry> addedFiles() {
        if (this.cachedAdds == null) {
            this.cacheChanges();
        }
        return this.cachedAdds;
    }

    public List<ManifestEntry> deletedFiles() {
        if (this.cachedDeletes == null) {
            this.cacheChanges();
        }
        return this.cachedDeletes;
    }

    private void cacheChanges() {
        ArrayList adds = Lists.newArrayList();
        ArrayList deletes = Lists.newArrayList();
        try (CloseableIterable<ManifestEntry> entries = this.entries(this.fileSchema.select(CHANGE_COLUMNS));){
            for (ManifestEntry entry : entries) {
                switch (entry.status()) {
                    case ADDED: {
                        adds.add(entry.copyWithoutStats());
                        break;
                    }
                    case DELETED: {
                        deletes.add(entry.copyWithoutStats());
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to close manifest entries", new Object[0]);
        }
        this.cachedAdds = adds;
        this.cachedDeletes = deletes;
    }

    CloseableIterable<ManifestEntry> entries() {
        return this.entries(this.fileSchema);
    }

    CloseableIterable<ManifestEntry> entries(Schema fileProjection) {
        FileFormat format = FileFormat.fromFileName((CharSequence)this.file.location());
        Preconditions.checkArgument((format != null ? 1 : 0) != 0, (String)"Unable to determine format of manifest: %s", (Object)this.file);
        switch (format) {
            case AVRO: {
                AvroIterable<ManifestEntry> reader = Avro.read(this.file).project(ManifestEntry.wrapFileSchema(fileProjection.asStruct())).rename("manifest_entry", ManifestEntry.class.getName()).rename("partition", PartitionData.class.getName()).rename("r102", PartitionData.class.getName()).rename("data_file", GenericDataFile.class.getName()).rename("r2", GenericDataFile.class.getName()).reuseContainers().build();
                this.addCloseable((Closeable)((Object)reader));
                return reader;
            }
        }
        throw new UnsupportedOperationException("Invalid format for manifest file: " + format);
    }

    public Iterator<DataFile> iterator() {
        return this.iterator((Expression)Expressions.alwaysTrue(), this.fileSchema);
    }

    Iterator<DataFile> iterator(Expression partFilter, Schema fileProjection) {
        return Iterables.transform((Iterable)Iterables.filter(this.entries(fileProjection), entry -> entry.status() != ManifestEntry.Status.DELETED), ManifestEntry::file).iterator();
    }
}

