/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestReader;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.PartitionSummary;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SnapshotSummary;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestWriter
implements FileAppender<DataFile> {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestWriter.class);
    private final OutputFile file;
    private final int specId;
    private final FileAppender<ManifestEntry> writer;
    private final long snapshotId;
    private final ManifestEntry reused;
    private final PartitionSummary stats;
    private boolean closed = false;
    private int addedFiles = 0;
    private int existingFiles = 0;
    private int deletedFiles = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ManifestFile copyAppendManifest(ManifestReader reader, OutputFile outputFile, long snapshotId, SnapshotSummary.Builder summaryBuilder) {
        ManifestWriter writer = new ManifestWriter(reader.spec(), outputFile, snapshotId);
        boolean threw = true;
        try {
            for (ManifestEntry entry : reader.entries()) {
                Preconditions.checkArgument((entry.status() == ManifestEntry.Status.ADDED ? 1 : 0) != 0, (Object)"Cannot append manifest: contains existing files");
                summaryBuilder.addedFile(reader.spec(), entry.file());
                writer.add(entry);
            }
            threw = false;
        }
        catch (Throwable throwable) {
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                if (threw) throw throwable;
                throw new RuntimeIOException(e, "Failed to close manifest: %s", new Object[]{outputFile});
            }
        }
        try {
            writer.close();
            return writer.toManifestFile();
        }
        catch (IOException e) {
            if (threw) return writer.toManifestFile();
            throw new RuntimeIOException(e, "Failed to close manifest: %s", new Object[]{outputFile});
        }
    }

    public static ManifestWriter write(PartitionSpec spec, OutputFile outputFile) {
        return new ManifestWriter(spec, outputFile, -1L);
    }

    ManifestWriter(PartitionSpec spec, OutputFile file, long snapshotId) {
        this.file = file;
        this.specId = spec.specId();
        this.writer = ManifestWriter.newAppender(FileFormat.AVRO, spec, file);
        this.snapshotId = snapshotId;
        this.reused = new ManifestEntry(spec.partitionType());
        this.stats = new PartitionSummary(spec);
    }

    void addEntry(ManifestEntry entry) {
        switch (entry.status()) {
            case ADDED: {
                ++this.addedFiles;
                break;
            }
            case EXISTING: {
                ++this.existingFiles;
                break;
            }
            case DELETED: {
                ++this.deletedFiles;
            }
        }
        this.stats.update(entry.file().partition());
        this.writer.add((Object)entry);
    }

    public void add(DataFile addedFile) {
        this.addEntry(this.reused.wrapAppend(this.snapshotId, addedFile));
    }

    public void add(ManifestEntry entry) {
        this.addEntry(this.reused.wrapAppend(this.snapshotId, entry.file()));
    }

    public void existing(DataFile existingFile, long fileSnapshotId) {
        this.addEntry(this.reused.wrapExisting(fileSnapshotId, existingFile));
    }

    void existing(ManifestEntry entry) {
        this.addEntry(this.reused.wrapExisting(entry.snapshotId(), entry.file()));
    }

    public void delete(DataFile deletedFile) {
        this.addEntry(this.reused.wrapDelete(this.snapshotId, deletedFile));
    }

    void delete(ManifestEntry entry) {
        this.addEntry(this.reused.wrapDelete(this.snapshotId, entry.file()));
    }

    public Metrics metrics() {
        return this.writer.metrics();
    }

    public long length() {
        return this.writer.length();
    }

    public ManifestFile toManifestFile() {
        Preconditions.checkState((boolean)this.closed, (Object)"Cannot build ManifestFile, writer is not closed");
        return new GenericManifestFile(this.file.location(), this.writer.length(), this.specId, this.snapshotId, this.addedFiles, this.existingFiles, this.deletedFiles, this.stats.summaries());
    }

    public void close() throws IOException {
        this.closed = true;
        this.writer.close();
    }

    private static <D> FileAppender<D> newAppender(FileFormat format, PartitionSpec spec, OutputFile file) {
        Schema manifestSchema = ManifestEntry.getSchema(spec.partitionType());
        try {
            switch (format) {
                case AVRO: {
                    return Avro.write(file).schema(manifestSchema).named("manifest_entry").meta("schema", SchemaParser.toJson(spec.schema())).meta("partition-spec", PartitionSpecParser.toJsonFields(spec)).meta("partition-spec-id", String.valueOf(spec.specId())).overwrite().build();
                }
            }
            throw new IllegalArgumentException("Unsupported format: " + format);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create manifest writer for path: " + file, new Object[0]);
        }
    }
}

