/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.iceberg.MetricsModes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsConfig {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsConfig.class);
    private Map<String, MetricsModes.MetricsMode> columnModes = Maps.newHashMap();
    private MetricsModes.MetricsMode defaultMode;

    private MetricsConfig() {
    }

    public static MetricsConfig getDefault() {
        MetricsConfig spec = new MetricsConfig();
        spec.defaultMode = MetricsModes.fromString("truncate(16)");
        return spec;
    }

    public static MetricsConfig fromProperties(Map<String, String> props) {
        MetricsConfig spec = new MetricsConfig();
        String defaultModeAsString = props.getOrDefault("write.metadata.metrics.default", "truncate(16)");
        try {
            spec.defaultMode = MetricsModes.fromString(defaultModeAsString);
        }
        catch (IllegalArgumentException err) {
            LOG.warn("Ignoring invalid default metrics mode: {}", (Object)defaultModeAsString, (Object)err);
            spec.defaultMode = MetricsModes.fromString("truncate(16)");
        }
        props.keySet().stream().filter(key -> key.startsWith("write.metadata.metrics.column.")).forEach(key -> {
            MetricsModes.MetricsMode mode;
            String columnAlias = key.replaceFirst("write.metadata.metrics.column.", "");
            try {
                mode = MetricsModes.fromString((String)props.get(key));
            }
            catch (IllegalArgumentException err) {
                LOG.warn("Ignoring invalid metrics mode for column {}: {}", new Object[]{columnAlias, props.get(key), err});
                mode = spec.defaultMode;
            }
            spec.columnModes.put(columnAlias, mode);
        });
        return spec;
    }

    public MetricsModes.MetricsMode columnMode(String columnAlias) {
        return this.columnModes.getOrDefault(columnAlias, this.defaultMode);
    }
}

