/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.apache.iceberg.PartitionField;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.JsonUtil;
import org.apache.iceberg.util.Pair;

public class PartitionSpecParser {
    private static final String SPEC_ID = "spec-id";
    private static final String FIELDS = "fields";
    private static final String SOURCE_ID = "source-id";
    private static final String TRANSFORM = "transform";
    private static final String NAME = "name";
    private static final Cache<Pair<Types.StructType, String>, PartitionSpec> SPEC_CACHE = Caffeine.newBuilder().weakValues().build();

    private PartitionSpecParser() {
    }

    public static void toJson(PartitionSpec spec, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(SPEC_ID, spec.specId());
        generator.writeFieldName(FIELDS);
        PartitionSpecParser.toJsonFields(spec, generator);
        generator.writeEndObject();
    }

    public static String toJson(PartitionSpec spec) {
        return PartitionSpecParser.toJson(spec, false);
    }

    public static String toJson(PartitionSpec spec, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            PartitionSpecParser.toJson(spec, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static PartitionSpec fromJson(Schema schema, JsonNode json) {
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse spec from non-object: %s", (Object)json);
        int specId = JsonUtil.getInt(SPEC_ID, json);
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema).withSpecId(specId);
        PartitionSpecParser.buildFromJsonFields(builder, json.get(FIELDS));
        return builder.build();
    }

    public static PartitionSpec fromJson(Schema schema, String json) {
        return (PartitionSpec)SPEC_CACHE.get(Pair.of(schema.asStruct(), json), schemaJsonPair -> {
            try {
                return PartitionSpecParser.fromJson(schema, (JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class));
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        });
    }

    static void toJsonFields(PartitionSpec spec, JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        for (PartitionField field : spec.fields()) {
            generator.writeStartObject();
            generator.writeStringField(NAME, field.name());
            generator.writeStringField(TRANSFORM, field.transform().toString());
            generator.writeNumberField(SOURCE_ID, field.sourceId());
            generator.writeEndObject();
        }
        generator.writeEndArray();
    }

    static String toJsonFields(PartitionSpec spec) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = JsonUtil.factory().createGenerator((Writer)writer);
            PartitionSpecParser.toJsonFields(spec, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    static PartitionSpec fromJsonFields(Schema schema, int specId, JsonNode json) {
        PartitionSpec.Builder builder = PartitionSpec.builderFor((Schema)schema).withSpecId(specId);
        PartitionSpecParser.buildFromJsonFields(builder, json);
        return builder.build();
    }

    static PartitionSpec fromJsonFields(Schema schema, int specId, String json) {
        try {
            return PartitionSpecParser.fromJsonFields(schema, specId, (JsonNode)JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to parse partition spec fields: " + json, new Object[0]);
        }
    }

    private static void buildFromJsonFields(PartitionSpec.Builder builder, JsonNode json) {
        Preconditions.checkArgument((boolean)json.isArray(), (String)"Cannot parse partition spec fields, not an array: %s", (Object)json);
        Iterator elements = json.elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            Preconditions.checkArgument((boolean)element.isObject(), (String)"Cannot parse partition field, not an object: %s", (Object)element);
            String name = JsonUtil.getString(NAME, element);
            String transform = JsonUtil.getString(TRANSFORM, element);
            int sourceId = JsonUtil.getInt(SOURCE_ID, element);
            builder.add(sourceId, name, transform);
        }
    }
}

