/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Preconditions;
import org.apache.iceberg.Rollback;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;

class RollbackToSnapshot
implements Rollback {
    private final TableOperations ops;
    private TableMetadata base = null;
    private Long targetSnapshotId = null;

    RollbackToSnapshot(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
    }

    public Rollback toSnapshotId(long snapshotId) {
        Preconditions.checkArgument((this.base.snapshot(snapshotId) != null ? 1 : 0) != 0, (String)"Cannot roll back to unknown snapshot id: %s", (long)snapshotId);
        this.targetSnapshotId = snapshotId;
        return this;
    }

    public Rollback toSnapshotAtTime(long timestampMillis) {
        long snapshotId = 0L;
        long snapshotTimestamp = 0L;
        for (Snapshot snapshot : this.base.snapshots()) {
            if (snapshot.timestampMillis() >= timestampMillis || snapshot.timestampMillis() <= snapshotTimestamp) continue;
            snapshotId = snapshot.snapshotId();
            snapshotTimestamp = snapshot.timestampMillis();
        }
        Preconditions.checkArgument((this.base.snapshot(snapshotId) != null ? 1 : 0) != 0, (String)"Cannot roll back, no valid snapshot older than: %s", (long)timestampMillis);
        this.targetSnapshotId = snapshotId;
        return this;
    }

    public Snapshot apply() {
        ValidationException.check((this.targetSnapshotId != null ? 1 : 0) != 0, (String)"Cannot roll back to unknown version: call toSnapshotId or toSnapshotAtTime", (Object[])new Object[0]);
        return this.base.snapshot(this.targetSnapshotId);
    }

    public void commit() {
        this.ops.commit(this.base, this.base.rollbackTo(this.apply()));
    }
}

