/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.mapping.NameMappingParser;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchemaUpdate
implements UpdateSchema {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaUpdate.class);
    private static final int TABLE_ROOT_ID = -1;
    private final TableOperations ops;
    private final TableMetadata base;
    private final Schema schema;
    private final List<Integer> deletes = Lists.newArrayList();
    private final Map<Integer, Types.NestedField> updates = Maps.newHashMap();
    private final Multimap<Integer, Types.NestedField> adds = Multimaps.newListMultimap((Map)Maps.newHashMap(), Lists::newArrayList);
    private int lastColumnId;

    SchemaUpdate(TableOperations ops) {
        this.ops = ops;
        this.base = ops.current();
        this.schema = this.base.schema();
        this.lastColumnId = this.base.lastColumnId();
    }

    SchemaUpdate(Schema schema, int lastColumnId) {
        this.ops = null;
        this.base = null;
        this.schema = schema;
        this.lastColumnId = lastColumnId;
    }

    public UpdateSchema addColumn(String name, Type type, String doc) {
        Preconditions.checkArgument((!name.contains(".") ? 1 : 0) != 0, (String)"Cannot add column with ambiguous name: %s, use addColumn(parent, name, type)", (Object)name);
        return this.addColumn(null, name, type, doc);
    }

    public UpdateSchema addColumn(String parent, String name, Type type, String doc) {
        int parentId = -1;
        if (parent != null) {
            Types.NestedField parentField = this.schema.findField(parent);
            Preconditions.checkArgument((parentField != null ? 1 : 0) != 0, (String)"Cannot find parent struct: %s", (Object)parent);
            Type parentType = parentField.type();
            if (parentType.isNestedType()) {
                Type.NestedType nested = parentType.asNestedType();
                if (nested.isMapType()) {
                    parentField = (Types.NestedField)nested.asMapType().fields().get(1);
                } else if (nested.isListType()) {
                    parentField = (Types.NestedField)nested.asListType().fields().get(0);
                }
            }
            Preconditions.checkArgument((parentField.type().isNestedType() && parentField.type().asNestedType().isStructType() ? 1 : 0) != 0, (String)"Cannot add to non-struct column: %s: %s", (Object)parent, (Object)parentField.type());
            parentId = parentField.fieldId();
            Preconditions.checkArgument((!this.deletes.contains(parentId) ? 1 : 0) != 0, (String)"Cannot add to a column that will be deleted: %s", (Object)parent);
            Preconditions.checkArgument((this.schema.findField(parent + "." + name) == null ? 1 : 0) != 0, (String)"Cannot add column, name already exists: %s.%s", (Object)parent, (Object)name);
        } else {
            Preconditions.checkArgument((this.schema.findField(name) == null ? 1 : 0) != 0, (String)"Cannot add column, name already exists: %s", (Object)name);
        }
        int newId = this.assignNewColumnId();
        this.adds.put((Object)parentId, (Object)Types.NestedField.optional((int)newId, (String)name, (Type)TypeUtil.assignFreshIds((Type)type, this::assignNewColumnId), (String)doc));
        return this;
    }

    public UpdateSchema deleteColumn(String name) {
        Types.NestedField field = this.schema.findField(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot delete missing column: %s", (Object)name);
        Preconditions.checkArgument((!this.adds.containsKey((Object)field.fieldId()) ? 1 : 0) != 0, (String)"Cannot delete a column that has additions: %s", (Object)name);
        Preconditions.checkArgument((!this.updates.containsKey(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot delete a column that has updates: %s", (Object)name);
        this.deletes.add(field.fieldId());
        return this;
    }

    public UpdateSchema renameColumn(String name, String newName) {
        Types.NestedField field = this.schema.findField(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot rename missing column: %s", (Object)name);
        Preconditions.checkArgument((newName != null ? 1 : 0) != 0, (Object)"Cannot rename a column to null");
        Preconditions.checkArgument((!this.deletes.contains(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot rename a column that will be deleted: %s", (Object)field.name());
        int fieldId = field.fieldId();
        Types.NestedField update = this.updates.get(fieldId);
        if (update != null) {
            this.updates.put(fieldId, Types.NestedField.required((int)fieldId, (String)newName, (Type)update.type(), (String)update.doc()));
        } else {
            this.updates.put(fieldId, Types.NestedField.required((int)fieldId, (String)newName, (Type)field.type(), (String)field.doc()));
        }
        return this;
    }

    public UpdateSchema updateColumn(String name, Type.PrimitiveType newType) {
        Types.NestedField field = this.schema.findField(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument((!this.deletes.contains(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot update a column that will be deleted: %s", (Object)field.name());
        Preconditions.checkArgument((boolean)TypeUtil.isPromotionAllowed((Type)field.type(), (Type.PrimitiveType)newType), (String)"Cannot change column type: %s: %s -> %s", (Object)name, (Object)field.type(), (Object)newType);
        int fieldId = field.fieldId();
        Types.NestedField rename = this.updates.get(fieldId);
        if (rename != null) {
            this.updates.put(fieldId, Types.NestedField.required((int)fieldId, (String)rename.name(), (Type)newType, (String)rename.doc()));
        } else {
            this.updates.put(fieldId, Types.NestedField.required((int)fieldId, (String)field.name(), (Type)newType, (String)field.doc()));
        }
        return this;
    }

    public UpdateSchema updateColumnDoc(String name, String doc) {
        Types.NestedField field = this.schema.findField(name);
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot update missing column: %s", (Object)name);
        Preconditions.checkArgument((!this.deletes.contains(field.fieldId()) ? 1 : 0) != 0, (String)"Cannot update a column that will be deleted: %s", (Object)field.name());
        int fieldId = field.fieldId();
        Types.NestedField update = this.updates.get(fieldId);
        if (update != null) {
            this.updates.put(fieldId, Types.NestedField.required((int)fieldId, (String)update.name(), (Type)update.type(), (String)doc));
        } else {
            this.updates.put(fieldId, Types.NestedField.required((int)fieldId, (String)field.name(), (Type)field.type(), (String)doc));
        }
        return this;
    }

    public Schema apply() {
        return SchemaUpdate.applyChanges(this.schema, this.deletes, this.updates, this.adds);
    }

    public void commit() {
        TableMetadata update = this.applyChangesToMapping(this.base.updateSchema(this.apply(), this.lastColumnId));
        this.ops.commit(this.base, update);
    }

    private int assignNewColumnId() {
        int next;
        this.lastColumnId = next = this.lastColumnId + 1;
        return next;
    }

    private TableMetadata applyChangesToMapping(TableMetadata metadata) {
        String mappingJson = metadata.property("schema.name-mapping.default", null);
        if (mappingJson != null) {
            try {
                NameMapping mapping = NameMappingParser.fromJson(mappingJson);
                NameMapping updated = MappingUtil.update(mapping, this.updates, this.adds);
                HashMap updatedProperties = Maps.newHashMap();
                updatedProperties.putAll(metadata.properties());
                updatedProperties.put("schema.name-mapping.default", NameMappingParser.toJson(updated));
                return metadata.replaceProperties(updatedProperties);
            }
            catch (RuntimeException e) {
                LOG.warn("Failed to update external schema mapping: {}", (Object)mappingJson, (Object)e);
            }
        }
        return metadata;
    }

    private static Schema applyChanges(Schema schema, List<Integer> deletes, Map<Integer, Types.NestedField> updates, Multimap<Integer, Types.NestedField> adds) {
        Types.StructType struct = ((Type)TypeUtil.visit((Schema)schema, (TypeUtil.SchemaVisitor)new ApplyChanges(deletes, updates, adds))).asNestedType().asStructType();
        return new Schema(struct.fields());
    }

    private static Types.StructType addFields(Types.StructType struct, Collection<Types.NestedField> adds) {
        ArrayList newFields = Lists.newArrayList((Iterable)struct.fields());
        newFields.addAll(adds);
        return Types.StructType.of((List)newFields);
    }

    private static class ApplyChanges
    extends TypeUtil.SchemaVisitor<Type> {
        private final List<Integer> deletes;
        private final Map<Integer, Types.NestedField> updates;
        private final Multimap<Integer, Types.NestedField> adds;

        private ApplyChanges(List<Integer> deletes, Map<Integer, Types.NestedField> updates, Multimap<Integer, Types.NestedField> adds) {
            this.deletes = deletes;
            this.updates = updates;
            this.adds = adds;
        }

        public Type schema(Schema schema, Type structResult) {
            Collection newColumns = this.adds.get((Object)-1);
            if (newColumns != null) {
                return SchemaUpdate.addFields(structResult.asNestedType().asStructType(), newColumns);
            }
            return structResult;
        }

        public Type struct(Types.StructType struct, List<Type> fieldResults) {
            boolean hasChange = false;
            ArrayList newFields = Lists.newArrayListWithExpectedSize((int)fieldResults.size());
            for (int i = 0; i < fieldResults.size(); ++i) {
                Type resultType = fieldResults.get(i);
                if (resultType == null) {
                    hasChange = true;
                    continue;
                }
                Types.NestedField field = (Types.NestedField)struct.fields().get(i);
                String name = field.name();
                String doc = field.doc();
                Types.NestedField update = this.updates.get(field.fieldId());
                if (update != null) {
                    name = update.name();
                    doc = update.doc();
                }
                if (!name.equals(field.name()) || field.type() != resultType || !Objects.equals(doc, field.doc())) {
                    hasChange = true;
                    if (field.isOptional()) {
                        newFields.add(Types.NestedField.optional((int)field.fieldId(), (String)name, (Type)resultType, (String)doc));
                        continue;
                    }
                    newFields.add(Types.NestedField.required((int)field.fieldId(), (String)name, (Type)resultType, (String)doc));
                    continue;
                }
                newFields.add(field);
            }
            if (hasChange) {
                return Types.StructType.of((List)newFields);
            }
            return struct;
        }

        public Type field(Types.NestedField field, Type fieldResult) {
            int fieldId = field.fieldId();
            if (this.deletes.contains(fieldId)) {
                return null;
            }
            Types.NestedField update = this.updates.get(field.fieldId());
            if (update != null && update.type() != field.type()) {
                return update.type();
            }
            Collection newFields = this.adds.get((Object)fieldId);
            if (newFields != null && !newFields.isEmpty()) {
                return SchemaUpdate.addFields(fieldResult.asNestedType().asStructType(), newFields);
            }
            return fieldResult;
        }

        public Type list(Types.ListType list, Type result) {
            Type elementResult = this.field((Types.NestedField)list.fields().get(0), result);
            if (elementResult == null) {
                throw new IllegalArgumentException("Cannot delete element type from list: " + list);
            }
            if (list.elementType() == elementResult) {
                return list;
            }
            if (list.isElementOptional()) {
                return Types.ListType.ofOptional((int)list.elementId(), (Type)elementResult);
            }
            return Types.ListType.ofRequired((int)list.elementId(), (Type)elementResult);
        }

        public Type map(Types.MapType map, Type kResult, Type vResult) {
            int keyId = ((Types.NestedField)map.fields().get(0)).fieldId();
            if (this.deletes.contains(keyId)) {
                throw new IllegalArgumentException("Cannot delete map keys: " + map);
            }
            if (this.updates.containsKey(keyId)) {
                throw new IllegalArgumentException("Cannot update map keys: " + map);
            }
            if (this.adds.containsKey((Object)keyId)) {
                throw new IllegalArgumentException("Cannot add fields to map keys: " + map);
            }
            if (!map.keyType().equals(kResult)) {
                throw new IllegalArgumentException("Cannot alter map keys: " + map);
            }
            Type valueResult = this.field((Types.NestedField)map.fields().get(1), vResult);
            if (valueResult == null) {
                throw new IllegalArgumentException("Cannot delete value type from map: " + map);
            }
            if (map.valueType() == valueResult) {
                return map;
            }
            if (map.isValueOptional()) {
                return Types.MapType.ofOptional((int)map.keyId(), (int)map.valueId(), (Type)map.keyType(), (Type)valueResult);
            }
            return Types.MapType.ofRequired((int)map.keyId(), (int)map.valueId(), (Type)map.keyType(), (Type)valueResult);
        }

        public Type primitive(Type.PrimitiveType primitive) {
            return primitive;
        }
    }
}

