/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTableScan;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StaticTableScan;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;

public class SnapshotsTable
extends BaseMetadataTable {
    private static final Schema SNAPSHOT_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"committed_at", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)2, (String)"snapshot_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"parent_id", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"operation", (Type)Types.StringType.get()), Types.NestedField.optional((int)5, (String)"manifest_list", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"summary", (Type)Types.MapType.ofRequired((int)7, (int)8, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
    private final TableOperations ops;
    private final Table table;

    public SnapshotsTable(TableOperations ops, Table table) {
        this.ops = ops;
        this.table = table;
    }

    @Override
    Table table() {
        return this.table;
    }

    @Override
    String metadataTableName() {
        return "snapshots";
    }

    public TableScan newScan() {
        return new SnapshotsTableScan();
    }

    public String location() {
        return this.ops.current().file().location();
    }

    public Schema schema() {
        return SNAPSHOT_SCHEMA;
    }

    private DataTask task(BaseTableScan scan) {
        return StaticDataTask.of(this.ops.current().file(), this.ops.current().snapshots(), SnapshotsTable::snapshotToRow);
    }

    private static StaticDataTask.Row snapshotToRow(Snapshot snap) {
        return StaticDataTask.Row.of(snap.timestampMillis() * 1000L, snap.snapshotId(), snap.parentId(), snap.operation(), snap.manifestListLocation(), snap.summary());
    }

    private class SnapshotsTableScan
    extends StaticTableScan {
        SnapshotsTableScan() {
            super(SnapshotsTable.this.ops, SnapshotsTable.this.table, SNAPSHOT_SCHEMA, x$0 -> SnapshotsTable.this.task(x$0));
        }
    }
}

