/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Arrays;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;

class StaticDataTask
implements DataTask {
    private final DataFile metadataFile;
    private final StructLike[] rows;

    static <T> DataTask of(InputFile metadata, Iterable<T> values, Function<T, Row> transform) {
        return new StaticDataTask(metadata, Lists.newArrayList((Iterable)Iterables.transform(values, transform::apply)).toArray(new Row[0]));
    }

    private StaticDataTask(InputFile metadata, StructLike[] rows) {
        this.metadataFile = DataFiles.builder().withInputFile(metadata).withRecordCount(rows.length).withFormat(FileFormat.METADATA).build();
        this.rows = rows;
    }

    public CloseableIterable<StructLike> rows() {
        return CloseableIterable.withNoopClose(Arrays.asList(this.rows));
    }

    public DataFile file() {
        return this.metadataFile;
    }

    public PartitionSpec spec() {
        return PartitionSpec.unpartitioned();
    }

    public long start() {
        return 0L;
    }

    public long length() {
        return this.metadataFile.fileSizeInBytes();
    }

    public Expression residual() {
        return Expressions.alwaysTrue();
    }

    public Iterable<FileScanTask> split(long splitSize) {
        return ImmutableList.of((Object)this);
    }

    static class Row
    implements StructLike,
    Serializable {
        private final Object[] values;

        public static Row of(Object ... values) {
            return new Row(values);
        }

        private Row(Object ... values) {
            this.values = values;
        }

        public int size() {
            return this.values.length;
        }

        public <T> T get(int pos, Class<T> javaClass) {
            return javaClass.cast(this.values[pos]);
        }

        public <T> void set(int pos, T value) {
            throw new UnsupportedOperationException("Setting values is not supported");
        }
    }
}

